/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.execution;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryException;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.core.starter.enums.PluginType;
import org.apache.seatunnel.core.starter.execution.SourceTableInfo;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelFactoryDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class PluginUtil {
    protected static final String ENGINE_TYPE = "seatunnel";

    public static SourceTableInfo createSource(SeaTunnelFactoryDiscovery factoryDiscovery, SeaTunnelSourcePluginDiscovery sourcePluginDiscovery, PluginIdentifier pluginIdentifier, Config pluginConfig, JobContext jobContext) {
        List<CatalogTable> catalogTables;
        SeaTunnelSource source;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(pluginConfig);
        Optional<Factory> sourceFactory = factoryDiscovery.createOptionalPluginInstance(pluginIdentifier);
        boolean fallback = PluginUtil.isFallback(sourceFactory);
        if (fallback) {
            source = PluginUtil.fallbackCreate(sourcePluginDiscovery, pluginIdentifier, pluginConfig);
        } else {
            TableSourceFactoryContext context = new TableSourceFactoryContext(readonlyConfig, classLoader);
            ConfigValidator.of(context.getOptions()).validate(sourceFactory.get().optionRule());
            TableSource tableSource = ((TableSourceFactory)sourceFactory.get()).createSource(context);
            source = tableSource.createSource();
        }
        source.setJobContext(jobContext);
        PluginUtil.ensureJobModeMatch(jobContext, source);
        try {
            catalogTables = source.getProducedCatalogTables();
        }
        catch (UnsupportedOperationException e) {
            SeaTunnelDataType seaTunnelDataType = source.getProducedType();
            String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
            catalogTables = CatalogTableUtil.convertDataTypeToCatalogTables(seaTunnelDataType, tableId);
        }
        return new SourceTableInfo(source, catalogTables);
    }

    private static boolean isFallback(Optional<Factory> factory) {
        block3: {
            if (!factory.isPresent()) {
                return true;
            }
            try {
                ((TableSourceFactory)factory.get()).createSource(null);
            }
            catch (Exception e) {
                if (!(e instanceof UnsupportedOperationException) || !"The Factory has not been implemented and the deprecated Plugin will be used.".equals(e.getMessage())) break block3;
                return true;
            }
        }
        return false;
    }

    private static SeaTunnelSource fallbackCreate(SeaTunnelSourcePluginDiscovery sourcePluginDiscovery, PluginIdentifier pluginIdentifier, Config pluginConfig) {
        SeaTunnelSource source = (SeaTunnelSource)sourcePluginDiscovery.createPluginInstance(pluginIdentifier);
        source.prepare(pluginConfig);
        return source;
    }

    public static Optional<? extends Factory> createTransformFactory(SeaTunnelFactoryDiscovery factoryDiscovery, SeaTunnelTransformPluginDiscovery transformPluginDiscovery, Config transformConfig, List<URL> pluginJars) {
        PluginIdentifier pluginIdentifier = PluginIdentifier.of(ENGINE_TYPE, "transform", transformConfig.getString(CommonOptions.PLUGIN_NAME.key()));
        pluginJars.addAll(transformPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier)));
        try {
            return factoryDiscovery.createOptionalPluginInstance(pluginIdentifier);
        }
        catch (FactoryException e) {
            return Optional.empty();
        }
    }

    public static Optional<? extends Factory> createSinkFactory(SeaTunnelFactoryDiscovery factoryDiscovery, SeaTunnelSinkPluginDiscovery sinkPluginDiscovery, Config sinkConfig, List<URL> pluginJars) {
        PluginIdentifier pluginIdentifier = PluginIdentifier.of(ENGINE_TYPE, "sink", sinkConfig.getString(CommonOptions.PLUGIN_NAME.key()));
        pluginJars.addAll(sinkPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier)));
        try {
            return factoryDiscovery.createOptionalPluginInstance(pluginIdentifier);
        }
        catch (FactoryException e) {
            return Optional.empty();
        }
    }

    public static SeaTunnelSink createSink(Optional<? extends Factory> factory, Config sinkConfig, SeaTunnelSinkPluginDiscovery sinkPluginDiscovery, JobContext jobContext, List<CatalogTable> catalogTables, ClassLoader classLoader) {
        boolean fallBack;
        boolean bl = fallBack = !factory.isPresent() || PluginUtil.isFallback(factory.get());
        if (fallBack) {
            SeaTunnelSink sink = PluginUtil.fallbackCreateSink(sinkPluginDiscovery, PluginIdentifier.of(ENGINE_TYPE, PluginType.SINK.getType(), sinkConfig.getString(CommonOptions.PLUGIN_NAME.key())), sinkConfig);
            sink.setJobContext(jobContext);
            sink.setTypeInfo(catalogTables.get(0).getSeaTunnelRowType());
            return sink;
        }
        if (catalogTables.size() > 1) {
            HashMap<String, SeaTunnelSink> sinks = new HashMap<String, SeaTunnelSink>();
            ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(sinkConfig);
            catalogTables.forEach(catalogTable -> {
                TableSinkFactoryContext context = TableSinkFactoryContext.replacePlaceholderAndCreate(catalogTable, ReadonlyConfig.fromConfig(sinkConfig), classLoader, ((TableSinkFactory)factory.get()).excludeTablePlaceholderReplaceKeys());
                ConfigValidator.of(context.getOptions()).validate(((Factory)factory.get()).optionRule());
                SeaTunnelSink action = ((TableSinkFactory)factory.get()).createSink(context).createSink();
                action.setJobContext(jobContext);
                sinks.put(catalogTable.getTablePath().toString(), action);
            });
            return FactoryUtil.createMultiTableSink(sinks, readonlyConfig, classLoader);
        }
        TableSinkFactoryContext context = TableSinkFactoryContext.replacePlaceholderAndCreate(catalogTables.get(0), ReadonlyConfig.fromConfig(sinkConfig), classLoader, ((TableSinkFactory)factory.get()).excludeTablePlaceholderReplaceKeys());
        ConfigValidator.of(context.getOptions()).validate(factory.get().optionRule());
        SeaTunnelSink sink = ((TableSinkFactory)factory.get()).createSink(context).createSink();
        sink.setJobContext(jobContext);
        return sink;
    }

    public static boolean isFallback(Factory factory) {
        block2: {
            try {
                ((TableSinkFactory)factory).createSink(null);
            }
            catch (Exception e) {
                if (!(e instanceof UnsupportedOperationException) || !"The Factory has not been implemented and the deprecated Plugin will be used.".equals(e.getMessage())) break block2;
                return true;
            }
        }
        return false;
    }

    public static SeaTunnelSink fallbackCreateSink(SeaTunnelSinkPluginDiscovery sinkPluginDiscovery, PluginIdentifier pluginIdentifier, Config pluginConfig) {
        SeaTunnelSink source = (SeaTunnelSink)sinkPluginDiscovery.createPluginInstance(pluginIdentifier);
        source.prepare(pluginConfig);
        return source;
    }

    public static void ensureJobModeMatch(JobContext jobContext, SeaTunnelSource source) {
        if (jobContext.getJobMode() == JobMode.BATCH && source.getBoundedness() == Boundedness.UNBOUNDED) {
            throw new UnsupportedOperationException(String.format("'%s' source don't support off-line job.", source.getPluginName()));
        }
    }
}

