/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ConfigAdapter;
import org.apache.seatunnel.api.sink.TablePlaceholder;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.common.utils.ParserException;
import org.apache.seatunnel.common.utils.PlaceholderUtils;
import org.apache.seatunnel.core.starter.exception.ConfigCheckException;
import org.apache.seatunnel.core.starter.utils.ConfigAdapterUtils;
import org.apache.seatunnel.core.starter.utils.ConfigShadeUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigParseOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigSyntax;
import org.apache.seatunnel.shade.com.typesafe.config.impl.Parseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBuilder.class);
    public static final ConfigRenderOptions CONFIG_RENDER_OPTIONS = ConfigRenderOptions.concise().setFormatted(true);
    private static final String PLACEHOLDER_REGEX = "\\$\\{([^:{}]+)(?::[^}]*)?\\}";

    private ConfigBuilder() {
    }

    private static Config ofInner(@NonNull Path filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Config config = ConfigFactory.parseFile(filePath.toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true));
        return ConfigShadeUtils.decryptConfig(ConfigBuilder.backfillUserVariables(config, variables));
    }

    public static Config of(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Path path = Paths.get(filePath, new String[0]);
        return ConfigBuilder.of(path);
    }

    public static Config of(@NonNull String filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Path path = Paths.get(filePath, new String[0]);
        return ConfigBuilder.of(path, variables);
    }

    public static Config of(@NonNull Path filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return ConfigBuilder.of(filePath, null);
    }

    public static Config of(@NonNull Path filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        log.info("Loading config file from path: {}", (Object)filePath);
        Optional<ConfigAdapter> adapterSupplier = ConfigAdapterUtils.selectAdapter(filePath);
        Config config = adapterSupplier.map(adapter -> ConfigBuilder.of(adapter, filePath, variables)).orElseGet(() -> ConfigBuilder.ofInner(filePath, variables));
        boolean isJson = filePath.getFileName().toString().endsWith(".json");
        log.info("Parsed config file: \n{}", (Object)ConfigBuilder.mapToString(ConfigBuilder.configDesensitization(config.root().unwrapped())));
        return config;
    }

    public static Config of(@NonNull Map<String, Object> objectMap) {
        if (objectMap == null) {
            throw new NullPointerException("objectMap is marked non-null but is null");
        }
        return ConfigBuilder.of(objectMap, false, false);
    }

    public static Config of(@NonNull Map<String, Object> objectMap, boolean isEncrypt, boolean isJson) {
        if (objectMap == null) {
            throw new NullPointerException("objectMap is marked non-null but is null");
        }
        log.info("Loading config file from objectMap");
        Config config = ConfigFactory.parseMap(objectMap).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        if (!isEncrypt) {
            config = ConfigShadeUtils.decryptConfig(config);
        }
        log.info("Parsed config file: \n{}", (Object)ConfigBuilder.mapToString(ConfigBuilder.configDesensitization(config.root().unwrapped())));
        return config;
    }

    public static Map<String, Object> configDesensitization(Map<String, Object> configMap) {
        return configMap.entrySet().stream().collect(HashMap::new, (m3, p) -> {
            String key = (String)p.getKey();
            Object value = p.getValue();
            if (Arrays.asList(ConfigShadeUtils.DEFAULT_SENSITIVE_KEYWORDS).contains(key.toLowerCase())) {
                m3.put(key, "******");
            } else if (value instanceof Map) {
                m3.put(key, ConfigBuilder.configDesensitization((Map)value));
            } else if (value instanceof List) {
                List listValue = (List)value;
                List newList = listValue.stream().map(v -> {
                    if (v instanceof Map) {
                        return ConfigBuilder.configDesensitization((Map)v);
                    }
                    return v;
                }).collect(Collectors.toList());
                m3.put(key, newList);
            } else {
                m3.put(key, value);
            }
        }, HashMap::putAll);
    }

    public static Config of(@NonNull ConfigAdapter configAdapter, @NonNull Path filePath, List<String> variables) {
        if (configAdapter == null) {
            throw new NullPointerException("configAdapter is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        log.info("With config adapter spi {}", (Object)configAdapter.getClass().getName());
        try {
            Map<String, Object> flattenedMap = configAdapter.loadConfig(filePath);
            Config config = ConfigFactory.parseMap(flattenedMap);
            return ConfigShadeUtils.decryptConfig(ConfigBuilder.backfillUserVariables(config, variables));
        }
        catch (IllegalArgumentException | ParserException e) {
            throw e;
        }
        catch (Exception warn) {
            log.warn("Loading config failed with spi {}, fallback to HOCON loader.", (Object)configAdapter.getClass().getName());
            return ConfigBuilder.ofInner(filePath, variables);
        }
    }

    private static Config backfillUserVariables(Config config, List<String> variables) {
        if (variables != null) {
            variables.stream().filter(Objects::nonNull).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).peek(pair -> {
                if (TablePlaceholder.isSystemPlaceholder(pair[0])) {
                    throw new ConfigCheckException("System placeholders cannot be used. Incorrect config parameter: " + pair[0]);
                }
            }).forEach(pair -> System.setProperty(pair[0], pair[1]));
            Config systemConfig = Parseable.newProperties(System.getProperties(), ConfigParseOptions.defaults().setOriginDescription("system properties")).parse().toConfig();
            Config resolvedConfig = config.resolveWith(systemConfig, ConfigResolveOptions.defaults().setAllowUnresolved(true));
            Map<String, Object> configMap = resolvedConfig.root().unwrapped();
            configMap.forEach((key, value) -> {
                if (value instanceof Map) {
                    ConfigBuilder.processVariablesMap((Map)value);
                } else if (value instanceof List) {
                    ((List)value).forEach(map -> ConfigBuilder.processVariablesMap(map));
                }
            });
            return ConfigFactory.parseString(JsonUtils.toJsonString(configMap), ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON)).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true));
        }
        return config;
    }

    private static void processVariablesMap(Map<String, Object> mapValue) {
        mapValue.forEach((innerKey, innerValue) -> {
            if (innerValue instanceof Map) {
                ConfigBuilder.processVariablesMap((Map)innerValue);
            } else if (innerValue instanceof List) {
                mapValue.put((String)innerKey, ConfigBuilder.processVariablesList((List)innerValue));
            } else {
                ConfigBuilder.processVariable(innerKey, innerValue, mapValue);
            }
        });
    }

    private static List<?> processVariablesList(List<?> list) {
        return list.stream().map(variable -> {
            if (variable instanceof String) {
                String variableString = (String)variable;
                return ConfigBuilder.extractPlaceholder(variableString).stream().reduce(variableString, (result, placeholder) -> PlaceholderUtils.replacePlaceholders(result, placeholder, System.getProperty(placeholder), null));
            }
            return variable;
        }).collect(Collectors.toList());
    }

    private static void processVariable(String variableKey, Object variableValue, Map<String, Object> parentMap) {
        if (Objects.isNull(variableValue)) {
            return;
        }
        String variableString = variableValue.toString();
        List<String> placeholders = ConfigBuilder.extractPlaceholder(variableString);
        for (String placeholder : placeholders) {
            String replacedValue;
            variableString = replacedValue = PlaceholderUtils.replacePlaceholders(variableString, placeholder, System.getProperty(placeholder), null);
        }
        if (!placeholders.isEmpty()) {
            parentMap.put(variableKey, variableString);
        }
    }

    public static List<String> extractPlaceholder(String input) {
        Pattern pattern = Pattern.compile(PLACEHOLDER_REGEX);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        return placeholders;
    }

    public static String mapToString(Map<String, Object> configMap) {
        ConfigParseOptions configParseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON);
        Config config = ConfigFactory.parseString(JsonUtils.toJsonString(configMap), configParseOptions).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        return config.root().render(CONFIG_RENDER_OPTIONS);
    }
}

