/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.instance.impl.DefaultNodeContext;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Joiner;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.LiteNodeDropOutTcpIpJoiner;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelNodeContext
extends DefaultNodeContext {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelNodeContext.class);
    private final SeaTunnelConfig seaTunnelConfig;

    public SeaTunnelNodeContext(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.seaTunnelConfig = seaTunnelConfig;
    }

    @Override
    public com.hazelcast.instance.impl.NodeExtension createNodeExtension(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return new NodeExtension(node, this.seaTunnelConfig);
    }

    @Override
    public Joiner createJoiner(Node node) {
        JoinConfig join = ConfigAccessor.getActiveMemberNetworkConfig(this.seaTunnelConfig.getHazelcastConfig()).getJoin();
        join.verify();
        if (join.getTcpIpConfig().isEnabled()) {
            log.info("Using LiteNodeDropOutTcpIpJoiner TCP/IP discovery");
            return new LiteNodeDropOutTcpIpJoiner(node);
        }
        return super.createJoiner(node);
    }
}

