/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.MembershipAwareService;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.hadoop.fs.FileSystem;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.classloader.DefaultClassLoaderService;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.EventService;
import org.apache.seatunnel.engine.server.SeaTunnelHealthMonitor;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.service.jar.ConnectorPackageService;
import org.apache.seatunnel.engine.server.service.slot.DefaultSlotService;
import org.apache.seatunnel.engine.server.service.slot.SlotService;
import org.apache.seatunnel.engine.server.telemetry.metrics.entity.ThreadPoolStatus;

public class SeaTunnelServer
implements ManagedService,
MembershipAwareService,
LiveOperationsTracker {
    private static final ILogger LOGGER = Logger.getLogger(SeaTunnelServer.class);
    public static final String SERVICE_NAME = "st:impl:seaTunnelServer";
    private NodeEngineImpl nodeEngine;
    private final LiveOperationRegistry liveOperationRegistry;
    private volatile SlotService slotService;
    private TaskExecutionService taskExecutionService;
    private ClassLoaderService classLoaderService;
    private CoordinatorService coordinatorService;
    private ScheduledExecutorService monitorService;
    private SeaTunnelHealthMonitor seaTunnelHealthMonitor;
    private final SeaTunnelConfig seaTunnelConfig;
    private volatile boolean isRunning = true;
    private EventService eventService;

    public SeaTunnelServer(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.seaTunnelConfig = seaTunnelConfig;
        LOGGER.info("SeaTunnel server start...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotService getSlotService() {
        if (EngineConfig.ClusterRole.MASTER.ordinal() == this.seaTunnelConfig.getEngineConfig().getClusterRole().ordinal()) {
            return null;
        }
        if (this.slotService == null) {
            SeaTunnelServer seaTunnelServer = this;
            synchronized (seaTunnelServer) {
                if (this.slotService == null) {
                    DefaultSlotService service = new DefaultSlotService(this.nodeEngine, this.taskExecutionService, this.seaTunnelConfig.getEngineConfig().getSlotServiceConfig());
                    service.init();
                    this.slotService = service;
                }
            }
        }
        return this.slotService;
    }

    @Override
    public void init(NodeEngine engine, Properties hzProperties) {
        this.nodeEngine = (NodeEngineImpl)engine;
        this.classLoaderService = new DefaultClassLoaderService(this.seaTunnelConfig.getEngineConfig().isClassloaderCacheMode());
        this.eventService = new EventService(this.nodeEngine);
        if (EngineConfig.ClusterRole.MASTER_AND_WORKER.ordinal() == this.seaTunnelConfig.getEngineConfig().getClusterRole().ordinal()) {
            this.startWorker();
            this.startMaster();
        } else if (EngineConfig.ClusterRole.WORKER.ordinal() == this.seaTunnelConfig.getEngineConfig().getClusterRole().ordinal()) {
            this.startWorker();
        } else {
            this.startMaster();
        }
        this.seaTunnelHealthMonitor = new SeaTunnelHealthMonitor(((NodeEngineImpl)engine).getNode());
        FileSystem.Statistics statistics = new FileSystem.Statistics("SeaTunnel");
    }

    private void startMaster() {
        this.coordinatorService = new CoordinatorService(this.nodeEngine, this, this.seaTunnelConfig.getEngineConfig());
        this.monitorService = Executors.newSingleThreadScheduledExecutor();
        this.monitorService.scheduleAtFixedRate(this::printExecutionInfo, 0L, this.seaTunnelConfig.getEngineConfig().getPrintExecutionInfoInterval(), TimeUnit.SECONDS);
    }

    private void startWorker() {
        this.taskExecutionService = new TaskExecutionService(this.classLoaderService, this.nodeEngine, this.eventService);
        this.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this.taskExecutionService);
        this.taskExecutionService.start();
        this.getSlotService();
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.isRunning = false;
        if (this.taskExecutionService != null) {
            this.taskExecutionService.shutdown();
        }
        if (this.classLoaderService != null) {
            this.classLoaderService.close();
        }
        if (this.monitorService != null) {
            this.monitorService.shutdownNow();
        }
        if (this.slotService != null) {
            this.slotService.close();
        }
        if (this.coordinatorService != null) {
            this.coordinatorService.shutdown();
        }
        if (this.eventService != null) {
            this.eventService.shutdownNow();
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        try {
            if (this.isMasterNode()) {
                this.getCoordinatorService().memberRemoved(event);
            }
        }
        catch (SeaTunnelEngineException e) {
            LOGGER.severe("Error when handle member removed event", e);
        }
    }

    @Override
    public void populate(LiveOperations liveOperations) {
    }

    public String printMessage(String message) {
        LOGGER.info(this.nodeEngine.getThisAddress() + ":" + message);
        return message;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public CoordinatorService getCoordinatorService() {
        if (this.isMasterNode()) {
            int retryPause;
            String hazelcastInvocationMaxRetry = this.seaTunnelConfig.getHazelcastConfig().getProperty(ClusterProperty.INVOCATION_MAX_RETRY_COUNT.getName());
            int maxRetry = hazelcastInvocationMaxRetry == null ? Integer.parseInt(ClusterProperty.INVOCATION_MAX_RETRY_COUNT.getDefaultValue()) * 2 : Integer.parseInt(hazelcastInvocationMaxRetry) * 2;
            String hazelcastRetryPause = this.seaTunnelConfig.getHazelcastConfig().getProperty(ClusterProperty.INVOCATION_RETRY_PAUSE.getName());
            int n = retryPause = hazelcastRetryPause == null ? Integer.parseInt(ClusterProperty.INVOCATION_RETRY_PAUSE.getDefaultValue()) : Integer.parseInt(hazelcastRetryPause);
            for (int retryCount = 0; this.isRunning && retryCount < maxRetry && !this.coordinatorService.isCoordinatorActive() && this.isMasterNode(); ++retryCount) {
                try {
                    LOGGER.warning("This is master node, waiting the coordinator service init finished");
                    Thread.sleep(retryPause);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.coordinatorService.isCoordinatorActive()) {
                return this.coordinatorService;
            }
            if (!this.isMasterNode()) {
                throw new SeaTunnelEngineException("This is not a master node now.");
            }
            throw new SeaTunnelEngineException("Can not get coordinator service from an active master node.");
        }
        throw new SeaTunnelEngineException("Please don't get coordinator service from an inactive master node");
    }

    public TaskExecutionService getTaskExecutionService() {
        return this.taskExecutionService;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public boolean taskIsEnded(@NonNull TaskGroupLocation taskGroupLocation) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked non-null but is null");
        }
        IMap runningJobState = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobState");
        Object taskState = runningJobState.get(taskGroupLocation);
        return taskState != null && ((ExecutionState)taskState).isEndState();
    }

    public boolean isMasterNode() {
        try {
            return Boolean.TRUE.equals(RetryUtils.retryWithException(() -> this.nodeEngine.getThisAddress().equals(this.nodeEngine.getMasterAddress()), new RetryUtils.RetryMaterial(30, true, exception -> this.isRunning && exception instanceof NullPointerException, 2000L)));
        }
        catch (InterruptedException e) {
            LOGGER.info("master node check interrupted");
            return false;
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException("cluster have no master node", e);
        }
    }

    private void printExecutionInfo() {
        this.coordinatorService.printExecutionInfo();
        if (this.coordinatorService.isCoordinatorActive() && this.isMasterNode()) {
            this.coordinatorService.printJobDetailInfo();
        }
    }

    public SeaTunnelConfig getSeaTunnelConfig() {
        return this.seaTunnelConfig;
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public ConnectorPackageService getConnectorPackageService() {
        return this.getCoordinatorService().getConnectorPackageService();
    }

    public ThreadPoolStatus getThreadPoolStatusMetrics() {
        return this.coordinatorService.getThreadPoolStatusMetrics();
    }

    public SeaTunnelHealthMonitor getSeaTunnelHealthMonitor() {
        return this.seaTunnelHealthMonitor;
    }

    public EventService getEventService() {
        return this.eventService;
    }
}

