/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.opeartion;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;
import org.apache.seatunnel.engine.server.service.slot.WrongTargetSlotException;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseSlotOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private static final Logger log = LoggerFactory.getLogger(ReleaseSlotOperation.class);
    private long jobID;
    private SlotProfile slotProfile;
    private WorkerProfile result;

    public ReleaseSlotOperation() {
    }

    public ReleaseSlotOperation(long jobID, SlotProfile slotProfile) {
        this.jobID = jobID;
        this.slotProfile = slotProfile;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        try {
            server.getSlotService().releaseSlot(this.jobID, this.slotProfile);
        }
        catch (WrongTargetSlotException ignore) {
            log.warn("wrong target release operation with job {} and slot profile {}, exception: {}", this.jobID, this.slotProfile, ExceptionUtils.getMessage(ignore));
        }
        this.result = server.getSlotService().getWorkerProfile();
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.slotProfile);
        out.writeLong(this.jobID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.slotProfile = (SlotProfile)in.readObject();
        this.jobID = in.readLong();
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

