/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.instance.impl.Node;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;
import org.apache.seatunnel.engine.server.telemetry.metrics.entity.JobCounter;

public class JobMetricExports
extends AbstractCollector {
    public JobMetricExports(Node node) {
        super(node);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (this.isMaster()) {
            CoordinatorService coordinatorService = this.getCoordinatorService();
            JobCounter jobCountMetrics = coordinatorService.getJobCountMetrics();
            GaugeMetricFamily metricFamily = new GaugeMetricFamily("job_count", "All job counts of seatunnel cluster ", this.clusterLabelNames("type"));
            metricFamily.addMetric(this.labelValues("canceled"), jobCountMetrics.getCanceledJobCount());
            metricFamily.addMetric(this.labelValues("cancelling"), jobCountMetrics.getCancellingJobCount());
            metricFamily.addMetric(this.labelValues("created"), jobCountMetrics.getCreatedJobCount());
            metricFamily.addMetric(this.labelValues("failed"), jobCountMetrics.getFailedJobCount());
            metricFamily.addMetric(this.labelValues("failing"), jobCountMetrics.getFailingJobCount());
            metricFamily.addMetric(this.labelValues("finished"), jobCountMetrics.getFinishedJobCount());
            metricFamily.addMetric(this.labelValues("running"), jobCountMetrics.getRunningJobCount());
            metricFamily.addMetric(this.labelValues("scheduled"), jobCountMetrics.getScheduledJobCount());
            mfs.add(metricFamily);
        }
        return mfs;
    }
}

