/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryField$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\u0007\u000e\u0001qAQa\u0010\u0001\u0005\u0002\u0001CQA\u0011\u0001\u0005B\rCQ\u0001\u0014\u0001\u0005B5CQa\u0016\u0001\u0005BaCQA\u001f\u0001\u0005BmDq!!\u0012\u0001\t\u0003\n9eB\u0004\u0002T5A\t!!\u0016\u0007\r1i\u0001\u0012AA,\u0011\u0019y\u0004\u0002\"\u0001\u0002n!9\u0011q\u000e\u0005\u0005\u0002\u0005E\u0004\"CA>\u0011\u0005\u0005I\u0011BA?\u0005Q9Um\u001c)beF,X\r\u001e$jY\u00164uN]7bi*\u0011abD\u0001\ba\u0006\u0014\u0018/^3u\u0015\t\u0001\u0012#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\n\u0014\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001;\u0005*3&\r\t\u0003=}i\u0011!D\u0005\u0003A5\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u!\t\u00113%D\u0001\u0010\u0013\t!sB\u0001\u0006GS2,gi\u001c:nCR\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\n\u0002\u000fM|WO]2fg&\u0011!f\n\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002-_5\tQF\u0003\u0002/+\u0005A\u0011N\u001c;fe:\fG.\u0003\u00021[\t9Aj\\4hS:<\u0007C\u0001\u001a=\u001d\t\u0019\u0014H\u0004\u00025o5\tQG\u0003\u000277\u00051AH]8pizJ\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003um\nq\u0001]1dW\u0006<WMC\u00019\u0013\tidH\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;w\u00051A(\u001b8jiz\"\u0012!\u0011\t\u0003=\u0001\t\u0011b\u001d5peRt\u0015-\\3\u0015\u0003\u0011\u0003\"!R%\u000f\u0005\u0019;\u0005C\u0001\u001b<\u0013\tA5(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%<\u0003\u0019)\u0017/^1mgR\u0011aJ\u0015\t\u0003\u001fBk\u0011aO\u0005\u0003#n\u0012qAQ8pY\u0016\fg\u000eC\u0003T\u0007\u0001\u0007A+A\u0003pi\",'\u000f\u0005\u0002P+&\u0011ak\u000f\u0002\u0004\u0003:L\u0018aC5oM\u0016\u00148k\u00195f[\u0006$B!\u00172i[B\u0019qJ\u0017/\n\u0005m[$AB(qi&|g\u000e\u0005\u0002^A6\taL\u0003\u0002`'\u0005)A/\u001f9fg&\u0011\u0011M\u0018\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B2\u0005\u0001\u0004!\u0017\u0001D:qCJ\\7+Z:tS>t\u0007CA3g\u001b\u0005\u0019\u0012BA4\u0014\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015IG\u00011\u0001k\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u000b.$E)\u0003\u0002m\u0017\n\u0019Q*\u00199\t\u000b9$\u0001\u0019A8\u0002\u000b\u0019LG.Z:\u0011\u0007I\u0002(/\u0003\u0002r}\t\u00191+Z9\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018A\u00014t\u0015\t9x#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003sR\u0014!BR5mKN#\u0018\r^;t\u0003y\u0011W/\u001b7e%\u0016\fG-\u001a:XSRD\u0007+\u0019:uSRLwN\u001c,bYV,7\u000fF\b}\u0003/\tI\"!\b\u0002\"\u0005\u0015\u0012\u0011GA\u001b!\u0015yUp`A\u0003\u0013\tq8HA\u0005Gk:\u001cG/[8ocA\u0019!%!\u0001\n\u0007\u0005\rqBA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015\u0011\u0014qAA\u0006\u0013\r\tIA\u0010\u0002\t\u0013R,'/\u0019;peB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012M\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003+\tyAA\u0006J]R,'O\\1m%><\b\"B2\u0006\u0001\u0004!\u0007BBA\u000e\u000b\u0001\u0007A,\u0001\u0006eCR\f7k\u00195f[\u0006Da!a\b\u0006\u0001\u0004a\u0016a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005\rR\u00011\u0001]\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a\n\u0006\u0001\u0004\tI#A\u0004gS2$XM]:\u0011\tI\u0002\u00181\u0006\t\u0004M\u00055\u0012bAA\u0018O\t1a)\u001b7uKJDa!a\r\u0006\u0001\u0004Q\u0017aB8qi&|gn\u001d\u0005\b\u0003o)\u0001\u0019AA\u001d\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b<\u0002\t\r|gNZ\u0005\u0005\u0003\u0007\niDA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019a*!\u0013\t\u000f\u0005-c\u00011\u0001\u0002N\u0005AA-\u0019;b)f\u0004X\rE\u0002^\u0003\u001fJ1!!\u0015_\u0005!!\u0015\r^1UsB,\u0017\u0001F$f_B\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002\u001f\u0011M1\u0001\"!\u0017,\u0003?\u00022aTA.\u0013\r\tif\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005\u0011\u0011n\u001c\u0006\u0003\u0003S\nAA[1wC&\u0019Q(a\u0019\u0015\u0005\u0005U\u0013AF7fe\u001e,7k\u00195f[\u0006\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u000fe\u000b\u0019(!\u001e\u0002z!)\u0011N\u0003a\u0001U\"1\u0011q\u000f\u0006A\u0002=\fABZ5mKN$v\u000eV8vG\"DQa\u0019\u0006A\u0002\u0011\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a \u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007SA!!\"\u0002h\u0005!A.\u00198h\u0013\u0011\tI)a!\u0003\r=\u0013'.Z2u\u0001")
public class GeoParquetFileFormat
extends ParquetFileFormat {
    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public String shortName() {
        return "geoparquet";
    }

    public boolean equals(Object other) {
        return other instanceof GeoParquetFileFormat;
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        String fieldGeometry = new GeoParquetOptions(parameters).fieldGeometry();
        GeometryField$.MODULE$.setFieldGeometry(fieldGeometry);
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = GeoParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                GeoParquetFilters parquetFilters = new GeoParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter((Filter)x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            String dateTimeRebaseModeConf = "";
            String int96RebaseModeConf = "";
            try {
                dateTimeRebaseModeConf = SQLConf$.MODULE$.get().getConfString("spark.sql.parquet.datetimeRebaseModeInRead");
                int96RebaseModeConf = SQLConf$.MODULE$.get().getConfString("spark.sql.parquet.int96RebaseModeInRead");
            }
            catch (NoSuchElementException e1) {
                dateTimeRebaseModeConf = SQLConf$.MODULE$.get().getConfString("spark.sql.legacy.parquet.datetimeRebaseModeInRead");
                try {
                    int96RebaseModeConf = SQLConf$.MODULE$.get().getConfString("spark.sql.legacy.parquet.int96RebaseModeInRead");
                }
                catch (NoSuchElementException e2) {
                    int96RebaseModeConf = dateTimeRebaseModeConf;
                }
            }
            Map map = GeoParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value datetimeRebaseMode = GeoDataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), dateTimeRebaseModeConf);
            Map map2 = GeoParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value int96RebaseMode = GeoDataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeConf);
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                this.logWarning((Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
            }
            this.logDebug((Function0 & Serializable)() -> "Falling back to parquet-mr");
            GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReaderIterator iter = new RecordReaderIterator((RecordReader)reader);
            taskContext.foreach((Function1 & Serializable)x$3 -> x$3.addTaskCompletionListener((Function1 & Serializable)x$4 -> {
                iter.close();
                return BoxedUnit.UNIT;
            }));
            reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
            Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
            UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
            if (partitionSchema.length() == 0) {
                iterator = iter.map((Function1)unsafeProjection);
            } else {
                JoinedRow joinedRow = new JoinedRow();
                iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : GeoParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return GeoParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }
}

