/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometryObjects;

import org.apache.sedona.common.utils.GeomUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Circle
extends Geometry {
    private final Geometry centerGeometry;
    private final Coordinate centerPoint;
    private Double radius;
    private Envelope MBR;

    public Circle(Geometry centerGeometry, Double givenRadius) {
        super(new GeometryFactory(centerGeometry.getPrecisionModel()));
        this.centerGeometry = centerGeometry;
        Envelope centerGeometryMBR = this.centerGeometry.getEnvelopeInternal();
        this.centerPoint = new Coordinate((centerGeometryMBR.getMinX() + centerGeometryMBR.getMaxX()) / 2.0, (centerGeometryMBR.getMinY() + centerGeometryMBR.getMaxY()) / 2.0);
        double width = centerGeometryMBR.getMaxX() - centerGeometryMBR.getMinX();
        double length = centerGeometryMBR.getMaxY() - centerGeometryMBR.getMinY();
        double centerGeometryInternalRadius = Math.sqrt(width * width + length * length) / 2.0;
        this.radius = givenRadius > centerGeometryInternalRadius ? givenRadius : centerGeometryInternalRadius;
        this.MBR = new Envelope(this.centerPoint.x - this.radius, this.centerPoint.x + this.radius, this.centerPoint.y - this.radius, this.centerPoint.y + this.radius);
        this.setUserData(centerGeometry.getUserData());
    }

    public Geometry getCenterGeometry() {
        return this.centerGeometry;
    }

    public Coordinate getCenterPoint() {
        return this.centerPoint;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double givenRadius) {
        Envelope centerGeometryMBR = this.centerGeometry.getEnvelopeInternal();
        double width = centerGeometryMBR.getMaxX() - centerGeometryMBR.getMinX();
        double length = centerGeometryMBR.getMaxY() - centerGeometryMBR.getMinY();
        double centerGeometryInternalRadius = Math.sqrt(width * width + length * length) / 2.0;
        this.radius = givenRadius > centerGeometryInternalRadius ? givenRadius : centerGeometryInternalRadius;
        this.MBR = new Envelope(this.centerPoint.x - this.radius, this.centerPoint.x + this.radius, this.centerPoint.y - this.radius, this.centerPoint.y + this.radius);
    }

    @Override
    public boolean covers(Geometry other) {
        Envelope otherEnvelope = other.getEnvelopeInternal();
        if (!this.getEnvelopeInternal().covers(otherEnvelope)) {
            return false;
        }
        if (other instanceof Point) {
            return this.covers((Point)other);
        }
        if (other instanceof LineString) {
            return this.covers((LineString)other);
        }
        if (other instanceof Polygon) {
            return this.covers(((Polygon)other).getExteriorRing());
        }
        if (other instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)other;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                if (this.covers(collection.getGeometryN(i))) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Circle.covers() doesn't support geometry type " + other.getGeometryType());
    }

    private boolean covers(LineString lineString) {
        for (int i = 0; i < lineString.getNumPoints(); ++i) {
            if (this.covers(lineString.getPointN(i))) continue;
            return false;
        }
        return true;
    }

    private boolean covers(Point point) {
        double deltaY;
        double deltaX = point.getX() - this.centerPoint.x;
        return deltaX * deltaX + (deltaY = point.getY() - this.centerPoint.y) * deltaY <= this.radius * this.radius;
    }

    @Override
    public boolean intersects(Geometry other) {
        Envelope otherEnvelope = other.getEnvelopeInternal();
        if (!this.getEnvelopeInternal().intersects(otherEnvelope)) {
            return false;
        }
        if (other instanceof Point) {
            return this.covers((Point)other);
        }
        if (other instanceof LineString) {
            return this.intersects((LineString)other);
        }
        if (other instanceof Polygon) {
            return this.intersects((Polygon)other);
        }
        if (other instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)other;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                if (!this.intersects(collection.getGeometryN(i))) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Circle.intersects() doesn't support geometry type " + other.getGeometryType());
    }

    private boolean intersects(Polygon polygon) {
        if (this.intersects(polygon.getExteriorRing())) {
            return true;
        }
        if (polygon.contains(this.factory.createPoint(this.centerPoint))) {
            return true;
        }
        if (polygon.getNumInteriorRing() == 0) {
            return false;
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            if (!this.intersects(polygon.getInteriorRingN(i))) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(LineString lineString) {
        for (int i = 0; i < lineString.getNumPoints() - 1; ++i) {
            if (!this.intersects(lineString.getPointN(i), lineString.getPointN(i + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(Point start, Point end) {
        double c;
        double a;
        double centerDeltaY;
        double deltaX = end.getX() - start.getX();
        double deltaY = end.getY() - start.getY();
        double centerDeltaX = start.getX() - this.centerPoint.x;
        double b = 2.0 * (deltaX * centerDeltaX + deltaY * (centerDeltaY = start.getY() - this.centerPoint.y));
        double discriminant = b * b - 4.0 * (a = deltaX * deltaX + deltaY * deltaY) * (c = centerDeltaX * centerDeltaX + centerDeltaY * centerDeltaY - this.radius * this.radius);
        if (discriminant < 0.0) {
            return false;
        }
        double t1 = (-b + Math.sqrt(discriminant)) / (2.0 * a);
        if (t1 >= 0.0 && t1 <= 1.0) {
            return true;
        }
        double t2 = (-b - Math.sqrt(discriminant)) / (2.0 * a);
        if (t2 >= 0.0 && t2 <= 1.0) {
            return true;
        }
        return Math.signum(t1) != Math.signum(t2);
    }

    @Override
    public String getGeometryType() {
        return "Circle";
    }

    @Override
    public Coordinate getCoordinate() {
        return this.centerGeometry.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.centerGeometry.getCoordinates();
    }

    @Override
    public int getNumPoints() {
        return this.centerGeometry.getNumPoints();
    }

    @Override
    public boolean isEmpty() {
        return this.centerGeometry.isEmpty();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection(null);
    }

    @Override
    public int getBoundaryDimension() {
        return 0;
    }

    @Override
    public Geometry reverse() {
        Geometry g = this.centerGeometry.reverse();
        Circle newCircle = new Circle(g, this.radius);
        return newCircle;
    }

    @Override
    protected Geometry reverseInternal() {
        Geometry g = this.centerGeometry.reverse();
        Circle newCircle = new Circle(g, this.radius);
        return newCircle;
    }

    @Override
    public Geometry copy() {
        Circle cloneCircle = new Circle(this.centerGeometry.copy(), this.radius);
        return cloneCircle;
    }

    @Override
    protected Geometry copyInternal() {
        Circle cloneCircle = new Circle(this.centerGeometry.copy(), this.radius);
        return cloneCircle;
    }

    @Override
    public boolean equalsExact(Geometry g, double tolerance) {
        String type1 = this.getGeometryType();
        String type2 = g.getGeometryType();
        double radius1 = this.radius;
        double radius2 = ((Circle)g).radius;
        if (type1 != type2) {
            return false;
        }
        if (radius1 != radius2) {
            return false;
        }
        return GeomUtils.equalsTopoGeom(this.centerGeometry, ((Circle)g).centerGeometry);
    }

    @Override
    public void apply(CoordinateFilter filter) {
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
    }

    @Override
    public void apply(GeometryFilter filter) {
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
    }

    @Override
    public void normalize() {
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.MBR;
    }

    @Override
    protected int compareToSameClass(Object other) {
        Envelope env = (Envelope)other;
        Envelope mbr = this.MBR;
        if (mbr.getMinX() < env.getMinX()) {
            return -1;
        }
        if (mbr.getMinX() > env.getMinX()) {
            return 1;
        }
        if (mbr.getMinY() < env.getMinY()) {
            return -1;
        }
        if (mbr.getMinY() > env.getMinY()) {
            return 1;
        }
        if (mbr.getMaxX() < env.getMaxX()) {
            return -1;
        }
        if (mbr.getMaxX() > env.getMaxX()) {
            return 1;
        }
        if (mbr.getMaxY() < env.getMaxY()) {
            return -1;
        }
        if (mbr.getMaxY() > env.getMaxY()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object other, CoordinateSequenceComparator comp) {
        Envelope env = (Envelope)other;
        Envelope mbr = this.MBR;
        if (mbr.getMinX() < env.getMinX()) {
            return -1;
        }
        if (mbr.getMinX() > env.getMinX()) {
            return 1;
        }
        if (mbr.getMinY() < env.getMinY()) {
            return -1;
        }
        if (mbr.getMinY() > env.getMinY()) {
            return 1;
        }
        if (mbr.getMaxX() < env.getMaxX()) {
            return -1;
        }
        if (mbr.getMaxX() > env.getMaxX()) {
            return 1;
        }
        if (mbr.getMaxY() < env.getMaxY()) {
            return -1;
        }
        if (mbr.getMaxY() > env.getMaxY()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected int getTypeCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "Circle of radius " + this.radius + " around " + this.centerGeometry;
    }
}

