/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.raster.RasterConstructors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class PixelFunctionEditors {
    public static GridCoverage2D setValues(GridCoverage2D raster, int band, int colX, int rowY, int width, int height, double[] values, boolean keepNoData) {
        RasterUtils.ensureBand(raster, band);
        if (values.length != width * height) {
            throw new IllegalArgumentException("Shape of 'values' doesn't match provided width and height.");
        }
        WritableRaster rasterCopied = PixelFunctionEditors.makeCopiedRaster(raster);
        Double noDataValue = null;
        if (keepNoData) {
            noDataValue = RasterBandAccessors.getBandNoDataValue(raster, band);
        }
        --colX;
        int iterator = 0;
        for (int j = --rowY; j < rowY + height; ++j) {
            for (int i = colX; i < colX + width; ++i) {
                double[] pixel = rasterCopied.getPixel(i, j, (double[])null);
                if (keepNoData && noDataValue == pixel[band - 1]) {
                    ++iterator;
                    continue;
                }
                pixel[band - 1] = values[iterator];
                rasterCopied.setPixel(i, j, pixel);
                ++iterator;
            }
        }
        return RasterUtils.create(rasterCopied, raster.getGridGeometry(), raster.getSampleDimensions());
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, int colX, int rowY, int width, int height, double[] values) {
        return PixelFunctionEditors.setValues(raster, band, colX, rowY, width, height, values, false);
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, Geometry geom, double value, boolean keepNoData) throws FactoryException, TransformException {
        GridCoverage2D rasterizedGeom;
        RasterUtils.ensureBand(raster, band);
        String bandDataType = RasterBandAccessors.getBandType(raster, band);
        Double noDataValue = null;
        if (keepNoData) {
            noDataValue = RasterBandAccessors.getBandNoDataValue(raster, band);
            rasterizedGeom = RasterConstructors.asRaster(geom, raster, bandDataType, value, noDataValue);
        } else {
            rasterizedGeom = RasterConstructors.asRaster(geom, raster, bandDataType, value);
        }
        Raster rasterizedGeomData = RasterUtils.getRaster(rasterizedGeom.getRenderedImage());
        double colX = RasterAccessors.getUpperLeftX(rasterizedGeom);
        double rowY = RasterAccessors.getUpperLeftY(rasterizedGeom);
        int height = RasterAccessors.getHeight(rasterizedGeom);
        int width = RasterAccessors.getWidth(rasterizedGeom);
        int heightOriginalRaster = RasterAccessors.getHeight(raster);
        int widthOriginalRaster = RasterAccessors.getWidth(raster);
        WritableRaster rasterCopied = PixelFunctionEditors.makeCopiedRaster(raster);
        String geometryType = geom.getGeometryType();
        if (geometryType.equalsIgnoreCase("Point") || geometryType.equalsIgnoreCase("MultiPoint")) {
            Coordinate[] coordinates;
            for (Coordinate pointCoordinate : coordinates = geom.getCoordinates()) {
                int[] pointLocation = raster.getGridGeometry().worldToGrid((DirectPosition)new DirectPosition2D(pointCoordinate.x, pointCoordinate.y)).getCoordinateValues();
                double[] pixel = rasterCopied.getPixel(pointLocation[0], pointLocation[1], (double[])null);
                pixel[band - 1] = rasterizedGeomData.getPixel(0, 0, (double[])null)[0];
                rasterCopied.setPixel(pointLocation[0], pointLocation[1], pixel);
            }
        } else {
            int[] pixelLocation = RasterUtils.getGridCoordinatesFromWorld(raster, colX, rowY);
            int x = pixelLocation[0];
            int y = pixelLocation[1];
            if (x < 0) {
                x = Math.abs(x);
            }
            if (y < 0) {
                y = Math.abs(y);
            }
            int j = 0;
            for (int l = y; j < heightOriginalRaster && l < height; ++j, ++l) {
                int i = 0;
                for (int k = x; i < widthOriginalRaster && k < width; ++i, ++k) {
                    double[] pixel = rasterCopied.getPixel(i, j, (double[])null);
                    double pixelNew = rasterizedGeomData.getPixel(k, l, (double[])null)[0];
                    if (pixelNew == 0.0 || keepNoData && noDataValue == pixel[band - 1]) continue;
                    pixel[band - 1] = pixelNew;
                    rasterCopied.setPixel(i, j, pixel);
                }
            }
        }
        return RasterUtils.create(rasterCopied, raster.getGridGeometry(), raster.getSampleDimensions());
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, Geometry geom, double value) throws FactoryException, TransformException {
        return PixelFunctionEditors.setValues(raster, band, geom, value, false);
    }

    public static GridCoverage2D setValue(GridCoverage2D raster, int band, int colX, int rowY, double newValue) {
        return PixelFunctionEditors.setValues(raster, band, colX, rowY, 1, 1, new double[]{newValue}, false);
    }

    public static GridCoverage2D setValue(GridCoverage2D raster, int colX, int rowY, double newValue) {
        return PixelFunctionEditors.setValues(raster, 1, colX, rowY, 1, 1, new double[]{newValue}, false);
    }

    private static WritableRaster makeCopiedRaster(GridCoverage2D raster) {
        RenderedImage originalImage = raster.getRenderedImage();
        Raster rasterTemp = RasterUtils.getRaster(originalImage);
        Point location = rasterTemp.getBounds().getLocation();
        WritableRaster wr = RasterFactory.createBandedRaster((int)rasterTemp.getDataBuffer().getDataType(), (int)originalImage.getWidth(), (int)originalImage.getHeight(), (int)raster.getNumSampleDimensions(), (Point)location);
        return raster.getRenderedImage().copyData(wr);
    }
}

