/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.imageio.ImageIO;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.core.BigBufferedImage;
import org.apache.sedona.viz.core.ImageGenerator;
import org.apache.sedona.viz.utils.ImageType;
import org.apache.sedona.viz.utils.RasterizationUtils;
import org.apache.sedona.viz.utils.S3Operator;
import scala.Tuple2;

public class ImageStitcher {
    static final Logger logger = Logger.getLogger(ImageStitcher.class);

    public static boolean stitchImagePartitionsFromLocalFile(String imageTilePath, int resolutionX, int resolutionY, int zoomLevel, int partitionOnX, int partitionOnY) throws Exception {
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Start]");
        BufferedImage stitchedImage = BigBufferedImage.create(resolutionX, resolutionY, 2);
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            BufferedImage imageTile = null;
            try {
                imageTile = ImageIO.read(new File("" + imageTilePath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i) + ".png"));
            }
            catch (IOException e) {
                continue;
            }
            Tuple2<Integer, Integer> partitionCoordinate = RasterizationUtils.Decode1DTo2DId(partitionOnX, partitionOnY, i);
            int partitionMinX = (Integer)partitionCoordinate._1 * Math.round(resolutionX / partitionOnX);
            int partitionMinY = (Integer)partitionCoordinate._2 * Math.round(resolutionY / partitionOnY);
            int[] rgbArray = imageTile.getRGB(0, 0, imageTile.getWidth(), imageTile.getHeight(), null, 0, imageTile.getWidth());
            int partitionMaxX = partitionMinX + imageTile.getWidth();
            int partitionMaxY = partitionMinY + imageTile.getHeight();
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching image tile..." + i + " ResolutionX " + resolutionX + " ResolutionY " + resolutionY));
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching a image tile..." + i + " MinX " + partitionMinX + " MaxX " + partitionMaxX + " MinY " + partitionMinY + " MaxY " + partitionMaxY));
            stitchedImage.setRGB(partitionMinX, partitionMinY, imageTile.getWidth(), imageTile.getHeight(), rgbArray, 0, imageTile.getWidth());
        }
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(stitchedImage, imageTilePath + "-" + zoomLevel + "-stitched", ImageType.PNG);
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Stop]");
        return true;
    }

    public static boolean stitchImagePartitionsFromS3File(String regionName, String accessKey, String secretKey, String bucketName, String imageTilePath, int resolutionX, int resolutionY, int zoomLevel, int partitionOnX, int partitionOnY) throws Exception {
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Start]");
        BufferedImage stitchedImage = BigBufferedImage.create(resolutionX, resolutionY, 2);
        S3Operator s3Operator = new S3Operator(regionName, accessKey, secretKey);
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            BufferedImage imageTile = null;
            try {
                imageTile = s3Operator.getImage(bucketName, imageTilePath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i) + ".png");
            }
            catch (AmazonS3Exception e) {
                continue;
            }
            Tuple2<Integer, Integer> partitionCoordinate = RasterizationUtils.Decode1DTo2DId(partitionOnX, partitionOnY, i);
            int partitionMinX = (Integer)partitionCoordinate._1 * Math.round(resolutionX / partitionOnX);
            int partitionMinY = (Integer)partitionCoordinate._2 * Math.round(resolutionY / partitionOnY);
            int[] rgbArray = imageTile.getRGB(0, 0, imageTile.getWidth(), imageTile.getHeight(), null, 0, imageTile.getWidth());
            int partitionMaxX = partitionMinX + imageTile.getWidth();
            int partitionMaxY = partitionMinY + imageTile.getHeight();
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching image tile..." + i + " ResolutionX " + resolutionX + " ResolutionY " + resolutionY));
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching a image tile..." + i + " MinX " + partitionMinX + " MaxX " + partitionMaxX + " MinY " + partitionMinY + " MaxY " + partitionMaxY));
            stitchedImage.setRGB(partitionMinX, partitionMinY, imageTile.getWidth(), imageTile.getHeight(), rgbArray, 0, imageTile.getWidth());
        }
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsS3File(stitchedImage, regionName, accessKey, secretKey, bucketName, imageTilePath + "-" + zoomLevel + "-stitched", ImageType.PNG);
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Stop]");
        return true;
    }

    public static boolean stitchImagePartitionsFromHadoopFile(String imageTilePath, int resolutionX, int resolutionY, int zoomLevel, int partitionOnX, int partitionOnY) throws Exception {
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Start]");
        BufferedImage stitchedImage = BigBufferedImage.create(resolutionX, resolutionY, 2);
        String[] splitString = imageTilePath.split(":");
        String hostName = splitString[0] + ":" + splitString[1];
        String[] portAndPath = splitString[2].split("/");
        String port = portAndPath[0];
        String localPath = "";
        for (int i = 1; i < portAndPath.length; ++i) {
            localPath = localPath + "/" + portAndPath[i];
        }
        Configuration hadoopConf = new Configuration();
        FileSystem hdfs = FileSystem.get((URI)new URI(hostName + ":" + port), (Configuration)hadoopConf);
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            BufferedImage imageTile = null;
            try {
                if (!hdfs.exists(new Path(localPath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i) + ".png"))) continue;
                FSDataInputStream inputStream = hdfs.open(new Path(localPath + "-" + i + ".png"));
                imageTile = ImageIO.read((InputStream)inputStream);
                inputStream.close();
                hdfs.close();
            }
            catch (IOException e) {
                continue;
            }
            Tuple2<Integer, Integer> partitionCoordinate = RasterizationUtils.Decode1DTo2DId(partitionOnX, partitionOnY, i);
            int partitionMinX = (Integer)partitionCoordinate._1 * Math.round(resolutionX / partitionOnX);
            int partitionMinY = (Integer)partitionCoordinate._2 * Math.round(resolutionY / partitionOnY);
            int[] rgbArray = imageTile.getRGB(0, 0, imageTile.getWidth(), imageTile.getHeight(), null, 0, imageTile.getWidth());
            int partitionMaxX = partitionMinX + imageTile.getWidth();
            int partitionMaxY = partitionMinY + imageTile.getHeight();
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching image tile..." + i + " ResolutionX " + resolutionX + " ResolutionY " + resolutionY));
            logger.debug((Object)("[Sedona-Viz][stitchImagePartitions] stitching a image tile..." + i + " MinX " + partitionMinX + " MaxX " + partitionMaxX + " MinY " + partitionMinY + " MaxY " + partitionMaxY));
            stitchedImage.setRGB(partitionMinX, partitionMinY, imageTile.getWidth(), imageTile.getHeight(), rgbArray, 0, imageTile.getWidth());
        }
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(stitchedImage, imageTilePath + "-" + zoomLevel + "-stitched", ImageType.PNG);
        logger.info((Object)"[Sedona-Viz][stitchImagePartitions][Stop]");
        return true;
    }
}

