/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.List;
import java.util.Set;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.MCIndexSegmentSetMutualIntersector;
import org.locationtech.jts.operation.relateng.DimensionLocation;
import org.locationtech.jts.operation.relateng.EdgeSegmentIntersector;
import org.locationtech.jts.operation.relateng.EdgeSetIntersector;
import org.locationtech.jts.operation.relateng.RelateGeometry;
import org.locationtech.jts.operation.relateng.RelateMatrixPredicate;
import org.locationtech.jts.operation.relateng.RelatePredicate;
import org.locationtech.jts.operation.relateng.RelateSegmentString;
import org.locationtech.jts.operation.relateng.TopologyComputer;
import org.locationtech.jts.operation.relateng.TopologyPredicate;

public class RelateNG {
    private BoundaryNodeRule boundaryNodeRule;
    private RelateGeometry geomA;
    private MCIndexSegmentSetMutualIntersector edgeMutualInt;

    public static boolean relate(Geometry a, Geometry b, TopologyPredicate pred) {
        RelateNG rng = new RelateNG(a, false);
        return rng.evaluate(b, pred);
    }

    public static boolean relate(Geometry a, Geometry b, TopologyPredicate pred, BoundaryNodeRule bnRule) {
        RelateNG rng = new RelateNG(a, false, bnRule);
        return rng.evaluate(b, pred);
    }

    public static boolean relate(Geometry a, Geometry b, String imPattern) {
        RelateNG rng = new RelateNG(a, false);
        return rng.evaluate(b, imPattern);
    }

    public static IntersectionMatrix relate(Geometry a, Geometry b) {
        RelateNG rng = new RelateNG(a, false);
        return rng.evaluate(b);
    }

    public static IntersectionMatrix relate(Geometry a, Geometry b, BoundaryNodeRule bnRule) {
        RelateNG rng = new RelateNG(a, false, bnRule);
        return rng.evaluate(b);
    }

    public static RelateNG prepare(Geometry a) {
        return new RelateNG(a, true);
    }

    public static RelateNG prepare(Geometry a, BoundaryNodeRule bnRule) {
        return new RelateNG(a, true, bnRule);
    }

    private RelateNG(Geometry inputA, boolean isPrepared) {
        this(inputA, isPrepared, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    private RelateNG(Geometry inputA, boolean isPrepared, BoundaryNodeRule bnRule) {
        this.boundaryNodeRule = bnRule;
        this.geomA = new RelateGeometry(inputA, isPrepared, this.boundaryNodeRule);
    }

    public IntersectionMatrix evaluate(Geometry b) {
        RelateMatrixPredicate rel = new RelateMatrixPredicate();
        this.evaluate(b, rel);
        return rel.getIM();
    }

    public boolean evaluate(Geometry b, String imPattern) {
        return this.evaluate(b, RelatePredicate.matches(imPattern));
    }

    public boolean evaluate(Geometry b, TopologyPredicate predicate) {
        if (!this.hasRequiredEnvelopeInteraction(b, predicate)) {
            return false;
        }
        RelateGeometry geomB = new RelateGeometry(b, this.boundaryNodeRule);
        if (this.geomA.isEmpty() && geomB.isEmpty()) {
            return this.finishValue(predicate);
        }
        int dimA = this.geomA.getDimensionReal();
        int dimB = geomB.getDimensionReal();
        predicate.init(dimA, dimB);
        if (predicate.isKnown()) {
            return this.finishValue(predicate);
        }
        predicate.init(this.geomA.getEnvelope(), geomB.getEnvelope());
        if (predicate.isKnown()) {
            return this.finishValue(predicate);
        }
        TopologyComputer topoComputer = new TopologyComputer(predicate, this.geomA, geomB);
        if (dimA == 0 && dimB == 0) {
            this.computePP(geomB, topoComputer);
            topoComputer.finish();
            return topoComputer.getResult();
        }
        this.computeAtPoints(geomB, false, this.geomA, topoComputer);
        if (topoComputer.isResultKnown()) {
            return topoComputer.getResult();
        }
        this.computeAtPoints(this.geomA, true, geomB, topoComputer);
        if (topoComputer.isResultKnown()) {
            return topoComputer.getResult();
        }
        if (this.geomA.hasEdges() && geomB.hasEdges()) {
            this.computeAtEdges(geomB, topoComputer);
        }
        topoComputer.finish();
        return topoComputer.getResult();
    }

    private boolean hasRequiredEnvelopeInteraction(Geometry b, TopologyPredicate predicate) {
        Envelope envB = b.getEnvelopeInternal();
        boolean isInteracts = false;
        if (predicate.requireCovers(true)) {
            if (!this.geomA.getEnvelope().covers(envB)) {
                return false;
            }
            isInteracts = true;
        } else if (predicate.requireCovers(false)) {
            if (!envB.covers(this.geomA.getEnvelope())) {
                return false;
            }
            isInteracts = true;
        }
        return isInteracts || !predicate.requireInteraction() || this.geomA.getEnvelope().intersects(envB);
    }

    private boolean finishValue(TopologyPredicate predicate) {
        predicate.finish();
        return predicate.value();
    }

    private void computePP(RelateGeometry geomB, TopologyComputer topoComputer) {
        Set<Coordinate> ptsA = this.geomA.getUniquePoints();
        Set<Coordinate> ptsB = geomB.getUniquePoints();
        int numBinA = 0;
        for (Coordinate ptB : ptsB) {
            if (ptsA.contains(ptB)) {
                ++numBinA;
                topoComputer.addPointOnPointInterior(ptB);
            } else {
                topoComputer.addPointOnPointExterior(false, ptB);
            }
            if (!topoComputer.isResultKnown()) continue;
            return;
        }
        if (numBinA < ptsA.size()) {
            topoComputer.addPointOnPointExterior(true, null);
        }
    }

    private void computeAtPoints(RelateGeometry geom, boolean isA, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        boolean checkDisjointPoints;
        boolean isResultKnown = false;
        isResultKnown = this.computePoints(geom, isA, geomTarget, topoComputer);
        if (isResultKnown) {
            return;
        }
        boolean bl = checkDisjointPoints = geomTarget.hasDimension(2) || topoComputer.isExteriorCheckRequired(isA);
        if (!checkDisjointPoints) {
            return;
        }
        isResultKnown = this.computeLineEnds(geom, isA, geomTarget, topoComputer);
        if (isResultKnown) {
            return;
        }
        this.computeAreaVertex(geom, isA, geomTarget, topoComputer);
    }

    private boolean computePoints(RelateGeometry geom, boolean isA, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        if (!geom.hasDimension(0)) {
            return false;
        }
        List<Point> points = geom.getEffectivePoints();
        for (Point point : points) {
            if (point.isEmpty()) continue;
            Coordinate pt = point.getCoordinate();
            this.computePoint(isA, pt, geomTarget, topoComputer);
            if (!topoComputer.isResultKnown()) continue;
            return true;
        }
        return false;
    }

    private void computePoint(boolean isA, Coordinate pt, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        int locDimTarget = geomTarget.locateWithDim(pt);
        int locTarget = DimensionLocation.location(locDimTarget);
        int dimTarget = DimensionLocation.dimension(locDimTarget, topoComputer.getDimension(!isA));
        topoComputer.addPointOnGeometry(isA, locTarget, dimTarget, pt);
    }

    private boolean computeLineEnds(RelateGeometry geom, boolean isA, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        if (!geom.hasDimension(1)) {
            return false;
        }
        boolean hasExteriorIntersection = false;
        GeometryCollectionIterator geomi = new GeometryCollectionIterator(geom.getGeometry());
        while (geomi.hasNext()) {
            Geometry elem = (Geometry)geomi.next();
            if (elem.isEmpty() || !(elem instanceof LineString) || hasExteriorIntersection && elem.getEnvelopeInternal().disjoint(geomTarget.getEnvelope())) continue;
            LineString line = (LineString)elem;
            Coordinate e0 = line.getCoordinateN(0);
            hasExteriorIntersection |= this.computeLineEnd(geom, isA, e0, geomTarget, topoComputer);
            if (topoComputer.isResultKnown()) {
                return true;
            }
            if (line.isClosed()) continue;
            Coordinate e1 = line.getCoordinateN(line.getNumPoints() - 1);
            hasExteriorIntersection |= this.computeLineEnd(geom, isA, e1, geomTarget, topoComputer);
            if (!topoComputer.isResultKnown()) continue;
            return true;
        }
        return false;
    }

    private boolean computeLineEnd(RelateGeometry geom, boolean isA, Coordinate pt, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        int locDimLineEnd = geom.locateLineEndWithDim(pt);
        int dimLineEnd = DimensionLocation.dimension(locDimLineEnd, topoComputer.getDimension(isA));
        if (dimLineEnd != 1) {
            return false;
        }
        int locLineEnd = DimensionLocation.location(locDimLineEnd);
        int locDimTarget = geomTarget.locateWithDim(pt);
        int locTarget = DimensionLocation.location(locDimTarget);
        int dimTarget = DimensionLocation.dimension(locDimTarget, topoComputer.getDimension(!isA));
        topoComputer.addLineEndOnGeometry(isA, locLineEnd, locTarget, dimTarget, pt);
        return locTarget == 2;
    }

    private boolean computeAreaVertex(RelateGeometry geom, boolean isA, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        if (!geom.hasDimension(2)) {
            return false;
        }
        if (geomTarget.getDimension() < 1) {
            return false;
        }
        boolean hasExteriorIntersection = false;
        GeometryCollectionIterator geomi = new GeometryCollectionIterator(geom.getGeometry());
        while (geomi.hasNext()) {
            Geometry elem = (Geometry)geomi.next();
            if (elem.isEmpty() || !(elem instanceof Polygon) || hasExteriorIntersection && elem.getEnvelopeInternal().disjoint(geomTarget.getEnvelope())) continue;
            Polygon poly = (Polygon)elem;
            hasExteriorIntersection |= this.computeAreaVertex(geom, isA, poly.getExteriorRing(), geomTarget, topoComputer);
            if (topoComputer.isResultKnown()) {
                return true;
            }
            for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
                hasExteriorIntersection |= this.computeAreaVertex(geom, isA, poly.getInteriorRingN(j), geomTarget, topoComputer);
                if (!topoComputer.isResultKnown()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean computeAreaVertex(RelateGeometry geom, boolean isA, LinearRing ring, RelateGeometry geomTarget, TopologyComputer topoComputer) {
        Coordinate pt = ring.getCoordinate();
        int locArea = geom.locateAreaVertex(pt);
        int locDimTarget = geomTarget.locateWithDim(pt);
        int locTarget = DimensionLocation.location(locDimTarget);
        int dimTarget = DimensionLocation.dimension(locDimTarget, topoComputer.getDimension(!isA));
        topoComputer.addAreaVertex(isA, locArea, locTarget, dimTarget, pt);
        return locTarget == 2;
    }

    private void computeAtEdges(RelateGeometry geomB, TopologyComputer topoComputer) {
        Envelope envInt = this.geomA.getEnvelope().intersection(geomB.getEnvelope());
        if (envInt.isNull()) {
            return;
        }
        List<RelateSegmentString> edgesB = geomB.extractSegmentStrings(false, envInt);
        EdgeSegmentIntersector intersector = new EdgeSegmentIntersector(topoComputer);
        if (topoComputer.isSelfNodingRequired()) {
            this.computeEdgesAll(edgesB, envInt, intersector);
        } else {
            this.computeEdgesMutual(edgesB, envInt, intersector);
        }
        if (topoComputer.isResultKnown()) {
            return;
        }
        topoComputer.evaluateNodes();
    }

    private void computeEdgesAll(List<RelateSegmentString> edgesB, Envelope envInt, EdgeSegmentIntersector intersector) {
        List<RelateSegmentString> edgesA = this.geomA.extractSegmentStrings(true, envInt);
        EdgeSetIntersector edgeInt = new EdgeSetIntersector(edgesA, edgesB, envInt);
        edgeInt.process(intersector);
    }

    private void computeEdgesMutual(List<RelateSegmentString> edgesB, Envelope envInt, EdgeSegmentIntersector intersector) {
        if (this.edgeMutualInt == null) {
            Envelope envExtract = this.geomA.isPrepared() ? null : envInt;
            List<RelateSegmentString> edgesA = this.geomA.extractSegmentStrings(true, envExtract);
            this.edgeMutualInt = new MCIndexSegmentSetMutualIntersector(edgesA, envExtract);
        }
        this.edgeMutualInt.process(edgesB, intersector);
    }
}

