/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.geometry.EncodedInts;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellIdVector;
import com.google.common.geometry.S2CellIdVectorCoder;
import com.google.common.geometry.S2Coder;
import com.google.common.geometry.S2Iterator;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeUtil;
import com.google.common.geometry.VectorCoder;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

@GwtIncompatible(value="S2LaxPolylineShape and S2LaxPolygonShape")
public class S2ShapeIndexCoder
implements S2Coder<S2ShapeIndex> {
    public static final S2ShapeIndexCoder INSTANCE = new S2ShapeIndexCoder(null);
    private final List<S2Shape> shapes;

    public S2ShapeIndexCoder(@Nullable List<S2Shape> shapes) {
        this.shapes = shapes;
    }

    @Override
    public void encode(S2ShapeIndex value, OutputStream output) throws IOException {
        long maxEdges = value.options().getMaxEdgesPerCell();
        EncodedInts.writeVarint64(output, maxEdges << 2 | 0L);
        ArrayList<S2CellId> cellIds = new ArrayList<S2CellId>();
        ArrayList<byte[]> encodedCells = new ArrayList<byte[]>();
        Multimap<S2Shape, Integer> shapeIds = S2ShapeUtil.shapeToShapeId(value);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        S2Iterator<S2ShapeIndex.Cell> it = value.iterator();
        while (!it.done()) {
            cellIds.add(it.id());
            S2ShapeIndexCoder.encodeCell(it.entry(), shapeIds, baos);
            encodedCells.add(baos.toByteArray());
            baos.reset();
            it.next();
        }
        S2CellIdVectorCoder.INSTANCE.encode((List<S2CellId>)cellIds, output);
        VectorCoder.BYTE_ARRAY.encode(encodedCells, output);
    }

    @Override
    public S2ShapeIndex decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        Preconditions.checkNotNull(this.shapes);
        return new EncodedS2ShapeIndex(data, cursor, this.shapes);
    }

    private static void encodeCell(S2ShapeIndex.Cell cell, Multimap<S2Shape, Integer> shapeIds, OutputStream output) throws IOException {
        Preconditions.checkArgument(cell.numShapes() < 0x10000000, "Too many shapes.");
        if (shapeIds.size() == 1) {
            int containsCenter;
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(0);
            int n = clipped.numEdges();
            Preconditions.checkArgument(n < 0x20000000, "Too many edges.");
            int n2 = containsCenter = clipped.containsCenter() ? 1 : 0;
            if (n >= 2 && n <= 17 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                EncodedInts.writeVarint64(output, clipped.edge(0) << 6 | n - 2 << 2 | containsCenter << 1);
            } else if (n == 1) {
                EncodedInts.writeVarint64(output, clipped.edge(0) << 3 | containsCenter << 2 | 1);
            } else {
                EncodedInts.writeVarint64(output, n << 3 | containsCenter << 2 | 3);
                S2ShapeIndexCoder.encodeEdges(clipped, output);
            }
        } else {
            if (cell.numShapes() > 1) {
                EncodedInts.writeVarint64(output, cell.numShapes() << 3 | 3);
            }
            int shapeIdBase = 0;
            for (int i = 0; i < cell.numShapes(); ++i) {
                S2ShapeIndex.S2ClippedShape clipped = cell.clipped(i);
                int containsCenter = clipped.containsCenter() ? 1 : 0;
                int clippedShapeId = -1;
                Collection<Integer> clippedShapeIds = shapeIds.get(clipped.shape());
                Iterator iterator = clippedShapeIds.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    if (id < shapeIdBase) continue;
                    clippedShapeId = id;
                    break;
                }
                assert (clippedShapeId >= shapeIdBase);
                int shapeDelta = clippedShapeId - shapeIdBase;
                shapeIdBase = clippedShapeId + 1;
                int n = clipped.numEdges();
                Preconditions.checkArgument(n < 0x20000000, "Too many edges.");
                if (n >= 1 && n <= 16 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                    EncodedInts.writeVarint64(output, clipped.edge(0) << 2 | containsCenter << 1);
                    EncodedInts.writeVarint64(output, shapeDelta << 4 | n - 1);
                    continue;
                }
                if (n == 0) {
                    EncodedInts.writeVarint64(output, shapeDelta << 4 | containsCenter << 3 | 7);
                    continue;
                }
                EncodedInts.writeVarint64(output, n - 1 << 3 | containsCenter << 2 | 1);
                EncodedInts.writeVarint64(output, shapeDelta);
                S2ShapeIndexCoder.encodeEdges(clipped, output);
            }
        }
    }

    private static void encodeEdges(S2ShapeIndex.S2ClippedShape clipped, OutputStream output) throws IOException {
        int edgeIdBase = 0;
        int numEdges = clipped.numEdges();
        for (int i = 0; i < numEdges; ++i) {
            int edgeId = clipped.edge(i);
            assert (edgeId >= edgeIdBase);
            int delta = edgeId - edgeIdBase;
            if (i + 1 == numEdges) {
                EncodedInts.writeVarint64(output, delta);
                continue;
            }
            int count = 1;
            while (i + 1 < numEdges && clipped.edge(i + 1) == edgeId + count) {
                ++count;
                ++i;
            }
            if (count < 8) {
                EncodedInts.writeVarint64(output, delta << 3 | count - 1);
            } else {
                EncodedInts.writeVarint64(output, count - 8 << 3 | 7);
                EncodedInts.writeVarint64(output, delta);
            }
            edgeIdBase = edgeId + count;
        }
    }

    private static int[] decodeEdges(int numEdges, PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        int[] edges = new int[numEdges];
        int edgeId = 0;
        int i = 0;
        while (i < numEdges) {
            long delta = data.readVarint64(cursor);
            if (i + 1 == numEdges) {
                edges[i++] = Ints.checkedCast((long)edgeId + delta);
                continue;
            }
            long count = (delta & 7L) + 1L;
            delta >>>= 3;
            if (count == 8L) {
                count = delta + 8L;
                delta = data.readVarint64(cursor);
            }
            edgeId += Ints.checkedCast(delta);
            while (count > 0L) {
                edges[i] = edgeId++;
                --count;
                ++i;
            }
        }
        return edges;
    }

    private static S2ShapeIndex.S2ClippedShape[] decodeClippedShapes(List<S2Shape> shapes, PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        if (shapes.size() == 1) {
            S2ShapeIndex.S2ClippedShape[] clippedShapes = new S2ShapeIndex.S2ClippedShape[1];
            long header = data.readVarint64(cursor);
            if ((header & 1L) == 0L) {
                int numEdges = Ints.checkedCast((header >>> 2 & 0xFL) + 2L);
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(0), (header & 2L) != 0L, Ints.checkedCast(header >>> 6), numEdges);
            } else if ((header & 2L) == 0L) {
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(0), (header & 4L) != 0L, Ints.checkedCast(header >>> 3), 1);
            } else {
                int numEdges = Ints.checkedCast(header >> 3);
                int[] edges = S2ShapeIndexCoder.decodeEdges(numEdges, data, cursor);
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(0), (header & 4L) != 0L, edges);
            }
            return clippedShapes;
        }
        long header = data.readVarint64(cursor);
        int numClipped = 1;
        if ((header & 7L) == 3L) {
            numClipped = Ints.checkedCast(header >>> 3);
            header = data.readVarint64(cursor);
        }
        S2ShapeIndex.S2ClippedShape[] clippedShapes = new S2ShapeIndex.S2ClippedShape[numClipped];
        long shapeId = 0L;
        int j = 0;
        while (j < numClipped) {
            int numEdges;
            if (j > 0) {
                header = data.readVarint64(cursor);
            }
            if ((header & 1L) == 0L) {
                long shapeIdCount = data.readVarint64(cursor);
                numEdges = Ints.checkedCast((shapeIdCount & 0xFL) + 1L);
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(Ints.checkedCast(shapeId += shapeIdCount >> 4)), (header & 2L) != 0L, Ints.checkedCast(header >>> 2), numEdges);
            } else if ((header & 7L) == 7L) {
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(Ints.checkedCast(shapeId += header >> 4)), (header & 8L) != 0L, 0, 0);
            } else {
                assert ((header & 3L) == 1L);
                long shapeDelta = data.readVarint64(cursor);
                numEdges = Ints.checkedCast((header >>> 3) + 1L);
                int[] edges = S2ShapeIndexCoder.decodeEdges(numEdges, data, cursor);
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.create(null, shapes.get(Ints.checkedCast(shapeId += shapeDelta)), (header & 4L) != 0L, edges);
            }
            ++j;
            ++shapeId;
        }
        return clippedShapes;
    }

    private static final class EncodedS2ShapeIndex
    extends S2ShapeIndex {
        private static final S2Shape UNDECODED_SHAPE = new S2ShapeUtil.S2EdgeVectorShape();
        private final S2ShapeIndex.Options options;
        private final S2Shape[] cachedShapes;
        private final S2CellIdVector encodedCellIds;
        private final List<S2ShapeIndex.S2ClippedShape[]> encodedCells;
        private final List<S2ShapeIndex.Cell> decodedCells;
        private final S2Coder<S2ShapeIndex.S2ClippedShape[]> clippedShapeArrayCoder = new S2Coder<S2ShapeIndex.S2ClippedShape[]>(){

            @Override
            public void encode(S2ShapeIndex.S2ClippedShape[] values, OutputStream output) {
                throw new UnsupportedOperationException();
            }

            @Override
            public S2ShapeIndex.S2ClippedShape[] decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
                return S2ShapeIndexCoder.decodeClippedShapes(shapes, data, cursor);
            }
        };

        EncodedS2ShapeIndex(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor, final List<S2Shape> shapeFactory) {
            long maxEdgesVersion = data.readVarint64(cursor);
            int version = (int)maxEdgesVersion & 3;
            Preconditions.checkArgument(version == 0, "Unknown encoding.");
            this.options = new S2ShapeIndex.Options();
            this.options.setMaxEdgesPerCell(Ints.checkedCast(maxEdgesVersion >> 2));
            this.cachedShapes = new S2Shape[Ints.checkedCast(shapeFactory.size())];
            Arrays.fill(this.cachedShapes, UNDECODED_SHAPE);
            this.shapes = new AbstractList<S2Shape>(){

                @Override
                public synchronized S2Shape get(int i) {
                    return cachedShapes[i] == UNDECODED_SHAPE ? (((EncodedS2ShapeIndex)this).cachedShapes[i] = (S2Shape)shapeFactory.get(i)) : cachedShapes[i];
                }

                @Override
                public int size() {
                    return cachedShapes.length;
                }
            };
            this.encodedCellIds = S2CellIdVectorCoder.INSTANCE.decode(data, cursor);
            this.encodedCells = new VectorCoder<S2ShapeIndex.S2ClippedShape[]>(this.clippedShapeArrayCoder).decode(data, cursor);
            ImmutableList.Builder cellsBuilder = ImmutableList.builder();
            for (int i = 0; i < this.encodedCellIds.size(); ++i) {
                cellsBuilder.add(new LazyCell(i));
            }
            this.decodedCells = cellsBuilder.build();
        }

        @Override
        public S2ShapeIndex.Options options() {
            return this.options;
        }

        @Override
        public void add(S2Shape shape) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(S2Shape shape) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public S2Iterator<S2ShapeIndex.Cell> iterator() {
            return S2Iterator.create(this.decodedCells, this.encodedCellIds::lowerBound);
        }

        @Override
        public boolean isFresh() {
            return true;
        }

        @Override
        void applyUpdates() {
            throw new UnsupportedOperationException();
        }

        private final class LazyCell
        extends S2ShapeIndex.Cell {
            private final int i;
            private S2CellId cachedCellId = null;
            private volatile S2ShapeIndex.S2ClippedShape[] cachedClippedShapes;

            LazyCell(int i) {
                this.i = i;
            }

            private S2ShapeIndex.S2ClippedShape[] loadClippedShapesFromCache() {
                if (this.cachedClippedShapes == null) {
                    this.cachedClippedShapes = (S2ShapeIndex.S2ClippedShape[])EncodedS2ShapeIndex.this.encodedCells.get(this.i);
                }
                return this.cachedClippedShapes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long id() {
                EncodedS2ShapeIndex encodedS2ShapeIndex = EncodedS2ShapeIndex.this;
                synchronized (encodedS2ShapeIndex) {
                    if (this.cachedCellId == null) {
                        this.cachedCellId = (S2CellId)EncodedS2ShapeIndex.this.encodedCellIds.get(this.i);
                    }
                    return this.cachedCellId.id();
                }
            }

            @Override
            public int numShapes() {
                return this.loadClippedShapesFromCache().length;
            }

            @Override
            public S2ShapeIndex.S2ClippedShape clipped(int i) {
                return this.loadClippedShapesFromCache()[i];
            }
        }
    }
}

