/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

class Rectangle {
    Rectangle() {
    }

    public static Polygon createFromSidePts(Coordinate baseRightPt, Coordinate baseLeftPt, Coordinate oppositePt, Coordinate leftSidePt, Coordinate rightSidePt, GeometryFactory factory) {
        double dx = baseLeftPt.x - baseRightPt.x;
        double dy = baseLeftPt.y - baseRightPt.y;
        double baseC = Rectangle.computeLineEquationC(dx, dy, baseRightPt);
        double oppC = Rectangle.computeLineEquationC(dx, dy, oppositePt);
        double leftC = Rectangle.computeLineEquationC(-dy, dx, leftSidePt);
        double rightC = Rectangle.computeLineEquationC(-dy, dx, rightSidePt);
        LineSegment baseLine = Rectangle.createLineForStandardEquation(-dy, dx, baseC);
        LineSegment oppLine = Rectangle.createLineForStandardEquation(-dy, dx, oppC);
        LineSegment leftLine = Rectangle.createLineForStandardEquation(-dx, -dy, leftC);
        LineSegment rightLine = Rectangle.createLineForStandardEquation(-dx, -dy, rightC);
        Coordinate p0 = rightSidePt.equals2D(baseRightPt) ? baseRightPt.copy() : baseLine.lineIntersection(rightLine);
        Coordinate p1 = leftSidePt.equals2D(baseLeftPt) ? baseLeftPt.copy() : baseLine.lineIntersection(leftLine);
        Coordinate p2 = leftSidePt.equals2D(oppositePt) ? oppositePt.copy() : oppLine.lineIntersection(leftLine);
        Coordinate p3 = rightSidePt.equals2D(oppositePt) ? oppositePt.copy() : oppLine.lineIntersection(rightLine);
        LinearRing shell = factory.createLinearRing(new Coordinate[]{p0, p1, p2, p3, p0.copy()});
        return factory.createPolygon(shell);
    }

    private static double computeLineEquationC(double a, double b, Coordinate p) {
        return a * p.y - b * p.x;
    }

    private static LineSegment createLineForStandardEquation(double a, double b, double c) {
        Coordinate p1;
        Coordinate p0;
        if (Math.abs(b) > Math.abs(a)) {
            p0 = new Coordinate(0.0, c / b);
            p1 = new Coordinate(1.0, c / b - a / b);
        } else {
            p0 = new Coordinate(c / a, 0.0);
            p1 = new Coordinate(c / a - b / a, 1.0);
        }
        return new LineSegment(p0, p1);
    }
}

