/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$GeometryColumnBoundingBox$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ruh\u0001\u0002.\\\u0001)Dq!!\u0001\u0001\t\u0003\t\u0019!\u0002\u0004\u0002\n\u0001!\u00111\u0002\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA-\u0011-\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003c\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\bC\u0006\u0002x\u0001\u0001\r\u0011!Q!\n\u0005\r\u0004bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003wB1\"a!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0006\"Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA?\u0011-\tY\t\u0001a\u0001\u0002\u0004%I!!$\t\u0017\u0005-\u0006\u00011AA\u0002\u0013%\u0011Q\u0016\u0005\f\u0003c\u0003\u0001\u0019!A!B\u0013\ty\tC\u0005\u00024\u0002\u0011\r\u0011\"\u0003\u00026\"A\u0011q\u0018\u0001!\u0002\u0013\t9\fC\u0005\u0002B\u0002\u0011\r\u0011\"\u0003\u00026\"A\u00111\u0019\u0001!\u0002\u0013\t9\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011\u0011\u001b\u0001!\u0002\u0013\tI\rC\u0005\u0002T\u0002\u0011\r\u0011\"\u0003\u0002V\"A\u0011Q\u001c\u0001!\u0002\u0013\t9\u000eC\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002b\"A\u00111\u001e\u0001!\u0002\u0013\t\u0019\u000fC\u0005\u0002n\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011q\u001e\u0001!\u0002\u0013\tI\rC\u0005\u0002r\u0002\u0011\r\u0011\"\u0003\u0002b\"A\u00111\u001f\u0001!\u0002\u0013\t\u0019\u000fC\u0005\u0002v\u0002\u0011\r\u0011\"\u0003\u0002x\"A!1\u001f\u0001!\u0002\u0013\tI\u0010C\u0005\u0003v\u0002\u0001\r\u0011\"\u0003\u0003x\"I!q \u0001A\u0002\u0013%1\u0011\u0001\u0005\t\u0007\u000b\u0001\u0001\u0015)\u0003\u0003z\"I1q\u0001\u0001A\u0002\u0013%1\u0011\u0002\u0005\n\u0007G\u0001\u0001\u0019!C\u0005\u0007KA\u0001b!\u000b\u0001A\u0003&11\u0002\u0005\n\u0007W\u0001!\u0019!C\u0005\u0007[A\u0001b!\r\u0001A\u0003%1q\u0006\u0005\n\u0007g\u0001!\u0019!C\u0005\u0007kA\u0001ba\u0010\u0001A\u0003%1q\u0007\u0005\b\u0007\u0003\u0002A\u0011IB\"\u0011\u001d\u0019\t\b\u0001C!\u0007gBqaa\u001e\u0001\t\u0003\u001aI\bC\u0004\u0004\u0004\u0002!\te!\"\t\u000f\r-\u0005\u0001\"\u0003\u0004\u000e\"91q\u0013\u0001\u0005\n\re\u0005\"CBV\u0001E\u0005I\u0011BBW\u0011\u001d\u0019\t\f\u0001C\u0005\u0007gCqa!0\u0001\t\u0003\u0019y\fC\u0004\u0004L\u0002!Ia!4\t\u000f\re\u0007\u0001\"\u0003\u0004\\\"91q\u001d\u0001\u0005\n\r%\bbBBw\u0001\u0011%1q^\u0004\b\u0005_Y\u0006\u0012\u0001B\u0019\r\u0019Q6\f#\u0001\u00034!9\u0011\u0011\u0001\u001e\u0005\u0002\tmbA\u0002B\u001fu\u0001\u0011y\u0004C\u0004\u0002\u0002q\"\tA!\u0011\t\u0013\t\u001dCH1A\u0005\u0002\t%\u0003\u0002\u0003BSy\u0001\u0006IAa\u0013\t\u0013\t\u001dFH1A\u0005\u0002\t%\u0006\u0002\u0003Bay\u0001\u0006IAa+\t\u000f\t-E\b\"\u0001\u0003D\u001a1!Q\n\u001e\u0001\u0005\u001fB!B!\u0015D\u0005\u0003\u0007I\u0011\u0001B*\u0011)\u0011Yf\u0011BA\u0002\u0013\u0005!Q\f\u0005\u000b\u0005C\u001a%\u0011!Q!\n\tU\u0003B\u0003B2\u0007\n\u0005\r\u0011\"\u0001\u0003T!Q!QM\"\u0003\u0002\u0004%\tAa\u001a\t\u0015\t-4I!A!B\u0013\u0011)\u0006\u0003\u0006\u0003n\r\u0013\t\u0019!C\u0001\u0005'B!Ba\u001cD\u0005\u0003\u0007I\u0011\u0001B9\u0011)\u0011)h\u0011B\u0001B\u0003&!Q\u000b\u0005\u000b\u0005o\u001a%\u00111A\u0005\u0002\tM\u0003B\u0003B=\u0007\n\u0005\r\u0011\"\u0001\u0003|!Q!qP\"\u0003\u0002\u0003\u0006KA!\u0016\t\u000f\u0005\u00051\t\"\u0001\u0003\u0002\"9!1R\"\u0005\u0002\t5u!\u0003Bdu\u0005\u0005\t\u0012\u0001Be\r%\u0011iEOA\u0001\u0012\u0003\u0011Y\rC\u0004\u0002\u0002M#\tA!4\t\u0013\t=7+%A\u0005\u0002\tE\u0007\"\u0003Bt'F\u0005I\u0011\u0001Bi\u0011%\u0011IoUI\u0001\n\u0003\u0011\t\u000eC\u0005\u0003lN\u000b\n\u0011\"\u0001\u0003R\"9!Q\u001e\u001e\u0005\n\t=(AF$f_B\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005qk\u0016a\u00029beF,X\r\u001e\u0006\u0003=~\u000b1\u0002Z1uCN|WO]2fg*\u0011\u0001-Y\u0001\nKb,7-\u001e;j_:T!AY2\u0002\u0007M\fHN\u0003\u0002eK\u0006)1\u000f]1sW*\u0011amZ\u0001\u0007CB\f7\r[3\u000b\u0003!\f1a\u001c:h\u0007\u0001\u00192\u0001A6{!\ra'\u000f^\u0007\u0002[*\u0011an\\\u0001\u0004CBL'B\u00019r\u0003\u0019A\u0017\rZ8pa*\u0011A,Z\u0005\u0003g6\u0014Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"!\u001e=\u000e\u0003YT!a^1\u0002\u0011\r\fG/\u00197zgRL!!\u001f<\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003wzl\u0011\u0001 \u0006\u0003{\u000e\f\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u007fr\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000b\u00012!a\u0002\u0001\u001b\u0005Y&a\u0003,bYV,wK]5uKJ\u0004\"\"!\u0004\u0002\u0014\u0005]\u00111EA\u0015\u001b\t\tyA\u0003\u0002\u0002\u0012\u0005)1oY1mC&!\u0011QCA\b\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiB^\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\"\u0005m!AE*qK\u000eL\u0017\r\\5{K\u0012<U\r\u001e;feN\u0004B!!\u0004\u0002&%!\u0011qEA\b\u0005\rIe\u000e\u001e\t\u0005\u0003\u001b\tY#\u0003\u0003\u0002.\u0005=!\u0001B+oSR\faa]2iK6\fWCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dC\u0006)A/\u001f9fg&!\u0011QHA\u001c\u0005)\u0019FO];diRK\b/Z\u0001\u000bg\u000eDW-\\1`I\u0015\fH\u0003BA\u0015\u0003\u0007B\u0011\"!\u0012\u0005\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\u0004tG\",W.\u0019\u0011\u0002!I|w\u000e\u001e$jK2$wK]5uKJ\u001cXCAA'!\u0019\ti!a\u0014\u0002T%!\u0011\u0011KA\b\u0005\u0015\t%O]1z!\r\t)FA\u0007\u0002\u0001\u0005!\"o\\8u\r&,G\u000eZ,sSR,'o]0%KF$B!!\u000b\u0002\\!I\u0011QI\u0004\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0012e>|GOR5fY\u0012<&/\u001b;feN\u0004\u0013A\u0004:fG>\u0014HmQ8ogVlWM]\u000b\u0003\u0003G\u0002B!!\u001a\u0002n5\u0011\u0011q\r\u0006\u0004]\u0006%$bAA6c\u0006\u0011\u0011n\\\u0005\u0005\u0003_\n9G\u0001\bSK\u000e|'\u000fZ\"p]N,X.\u001a:\u0002%I,7m\u001c:e\u0007>t7/^7fe~#S-\u001d\u000b\u0005\u0003S\t)\bC\u0005\u0002F)\t\t\u00111\u0001\u0002d\u0005y!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014\b%\u0001\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR,\"!! \u0011\t\u00055\u0011qP\u0005\u0005\u0003\u0003\u000byAA\u0004C_>dW-\u00198\u00029]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fGo\u0018\u0013fcR!\u0011\u0011FAD\u0011%\t)%DA\u0001\u0002\u0004\ti(A\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR\u0004\u0013aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,WCAAH!\u0011\t\t*a)\u000f\t\u0005M\u0015Q\u0014\b\u0005\u0003+\u000bI*\u0004\u0002\u0002\u0018*\u0011Q0Y\u0005\u0005\u00037\u000b9*A\u0004T#2\u001buN\u001c4\n\t\u0005}\u0015\u0011U\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0005\u00037\u000b9*\u0003\u0003\u0002&\u0006\u001d&!\u0002,bYV,\u0017\u0002BAU\u0003\u001f\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\u00069r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK~#S-\u001d\u000b\u0005\u0003S\ty\u000bC\u0005\u0002FA\t\t\u00111\u0001\u0002\u0010\u0006!r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK\u0002\nq\u0002^5nKN$\u0018-\u001c9Ck\u001a4WM]\u000b\u0003\u0003o\u0003b!!\u0004\u0002P\u0005e\u0006\u0003BA\u0007\u0003wKA!!0\u0002\u0010\t!!)\u001f;f\u0003A!\u0018.\\3ti\u0006l\u0007OQ;gM\u0016\u0014\b%A\u0007eK\u000eLW.\u00197Ck\u001a4WM]\u0001\u000fI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:!\u0003I!\u0017\r^3uS6,'+\u001a2bg\u0016lu\u000eZ3\u0016\u0005\u0005%\u0007\u0003BAf\u0003GsA!!&\u0002N&!\u0011qZAL\u0003QaUmZ1ds\n+\u0007.\u0019<j_J\u0004v\u000e\\5ds\u0006\u0019B-\u0019;fi&lWMU3cCN,Wj\u001c3fA\u0005qA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001cWCAAl!!\ti!!7\u0002$\u0005\r\u0012\u0002BAn\u0003\u001f\u0011\u0011BR;oGRLwN\\\u0019\u0002\u001f\u0011\fG/\u001a*fE\u0006\u001cXMR;oG\u0002\n1\u0003^5nKN$\u0018-\u001c9SK\n\f7/\u001a$v]\u000e,\"!a9\u0011\u0011\u00055\u0011\u0011\\As\u0003K\u0004B!!\u0004\u0002h&!\u0011\u0011^A\b\u0005\u0011auN\\4\u0002)QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2!\u0003=Ig\u000e^\u001d7%\u0016\u0014\u0017m]3N_\u0012,\u0017\u0001E5oif2$+\u001a2bg\u0016lu\u000eZ3!\u0003=Ig\u000e^\u001d7%\u0016\u0014\u0017m]3Gk:\u001c\u0017\u0001E5oif2$+\u001a2bg\u00164UO\\2!\u0003U9Wm\\7fiJL8i\u001c7v[:LeNZ8NCB,\"!!?\u0011\u0011\u0005m(QAA\u0012\u0005\u0013i!!!@\u000b\t\u0005}(\u0011A\u0001\b[V$\u0018M\u00197f\u0015\u0011\u0011\u0019!a\u0004\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\b\u0005u(aA'baB\u0019!1\u0002\u001f\u000f\u0007\t5\u0011H\u0004\u0003\u0003\u0010\t5b\u0002\u0002B\t\u0005WqAAa\u0005\u0003*9!!Q\u0003B\u0014\u001d\u0011\u00119B!\n\u000f\t\te!1\u0005\b\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)\u0019!qD5\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0017B\u00014h\u0013\t!W-\u0003\u0002cG&\u0011\u0001-Y\u0005\u0003=~K!\u0001X/\u0002-\u001d+w\u000eU1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peR\u00042!a\u0002;'\rQ$Q\u0007\t\u0005\u0003\u001b\u00119$\u0003\u0003\u0003:\u0005=!AB!osJ+g\r\u0006\u0002\u00032\t\u0011r)Z8nKR\u0014\u0018pQ8mk6t\u0017J\u001c4p'\ra$Q\u0007\u000b\u0003\u0005\u0007\u00022A!\u0012=\u001b\u0005Q\u0014\u0001\u00022c_b,\"Aa\u0013\u0011\u0007\t\u00153IA\rHK>lW\r\u001e:z\u0007>dW/\u001c8C_VtG-\u001b8h\u0005>D8cA\"\u00036\u0005!Q.\u001b8Y+\t\u0011)\u0006\u0005\u0003\u0002\u000e\t]\u0013\u0002\u0002B-\u0003\u001f\u0011a\u0001R8vE2,\u0017\u0001C7j]b{F%Z9\u0015\t\u0005%\"q\f\u0005\n\u0003\u000b*\u0015\u0011!a\u0001\u0005+\nQ!\\5o1\u0002\nA!\\5o3\u0006AQ.\u001b8Z?\u0012*\u0017\u000f\u0006\u0003\u0002*\t%\u0004\"CA#\u0011\u0006\u0005\t\u0019\u0001B+\u0003\u0015i\u0017N\\-!\u0003\u0011i\u0017\r\u001f-\u0002\u00115\f\u0007\u0010W0%KF$B!!\u000b\u0003t!I\u0011QI&\u0002\u0002\u0003\u0007!QK\u0001\u0006[\u0006D\b\fI\u0001\u0005[\u0006D\u0018,\u0001\u0005nCbLv\fJ3r)\u0011\tIC! \t\u0013\u0005\u0015c*!AA\u0002\tU\u0013!B7bqf\u0003CC\u0003B&\u0005\u0007\u0013)Ia\"\u0003\n\"I!\u0011\u000b)\u0011\u0002\u0003\u0007!Q\u000b\u0005\n\u0005G\u0002\u0006\u0013!a\u0001\u0005+B\u0011B!\u001cQ!\u0003\u0005\rA!\u0016\t\u0013\t]\u0004\u000b%AA\u0002\tU\u0013AB;qI\u0006$X\r\u0006\u0003\u0002*\t=\u0005b\u0002BI#\u0002\u0007!1S\u0001\u0005O\u0016|W\u000e\u0005\u0003\u0003\u0016\n\u0005VB\u0001BL\u0015\u0011\u0011\tJ!'\u000b\t\tm%QT\u0001\u0004UR\u001c(b\u0001BPO\u0006aAn\\2bi&|g\u000e^3dQ&!!1\u0015BL\u0005!9Um\\7fiJL\u0018!\u00022c_b\u0004\u0013!E:fK:<Um\\7fiJLH+\u001f9fgV\u0011!1\u0016\t\u0007\u0003w\u0014iK!-\n\t\t=\u0016Q \u0002\u0004'\u0016$\b\u0003\u0002BZ\u0005wsAA!.\u00038B!!1DA\b\u0013\u0011\u0011I,a\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iLa0\u0003\rM#(/\u001b8h\u0015\u0011\u0011I,a\u0004\u0002%M,WM\\$f_6,GO]=UsB,7\u000f\t\u000b\u0005\u0003S\u0011)\rC\u0004\u0003\u0012\n\u0003\rAa%\u00023\u001d+w.\\3uef\u001cu\u000e\\;n]\n{WO\u001c3j]\u001e\u0014u\u000e\u001f\t\u0004\u0005\u000b\u001a6cA*\u00036Q\u0011!\u0011Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM'\u0006\u0002B+\u0005+\\#Aa6\u0011\t\te'1]\u0007\u0003\u00057TAA!8\u0003`\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005C\fy!\u0001\u0006b]:|G/\u0019;j_:LAA!:\u0003\\\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\nQdZ3u'B\f'o[*rYB\u000b'/];fiJ{w/T3uC\u0012\fG/\u0019\u000b\u0005\u0005c\u0013\t\u0010C\u0004\u00020e\u0003\r!a\r\u0002-\u001d,w.\\3uef\u001cu\u000e\\;n]&sgm\\'ba\u0002\n\u0011cZ3p!\u0006\u0014\u0018/^3u-\u0016\u00148/[8o+\t\u0011I\u0010\u0005\u0004\u0002\u000e\tm(\u0011W\u0005\u0005\u0005{\fyA\u0001\u0004PaRLwN\\\u0001\u0016O\u0016|\u0007+\u0019:rk\u0016$h+\u001a:tS>tw\fJ3r)\u0011\tIca\u0001\t\u0013\u0005\u00153%!AA\u0002\te\u0018AE4f_B\u000b'/];fiZ+'o]5p]\u0002\nA\u0003Z3gCVdGoR3p!\u0006\u0014\u0018/^3u\u0007J\u001cXCAB\u0006!\u0019\tiAa?\u0004\u000eA!1qBB\u000f\u001d\u0011\u0019\tba\u0006\u000f\t\te11C\u0005\u0004\u0007+9\u0017A\u00026t_:$4/\u0003\u0003\u0004\u001a\rm\u0011a\u00029bG.\fw-\u001a\u0006\u0004\u0007+9\u0017\u0002BB\u0010\u0007C\u0011aA\u0013,bYV,'\u0002BB\r\u00077\t\u0001\u0004Z3gCVdGoR3p!\u0006\u0014\u0018/^3u\u0007J\u001cx\fJ3r)\u0011\tIca\n\t\u0013\u0005\u0015c%!AA\u0002\r-\u0011!\u00063fM\u0006,H\u000e^$f_B\u000b'/];fi\u000e\u00138\u000fI\u0001\u0017O\u0016|\u0007+\u0019:rk\u0016$8i\u001c7v[:\u001c%o]'baV\u00111q\u0006\t\t\u0003w\u0014)A!-\u0004\f\u00059r-Z8QCJ\fX/\u001a;D_2,XN\\\"sg6\u000b\u0007\u000fI\u0001\u001cO\u0016|\u0007+\u0019:rk\u0016$8i\u001c7v[:\u001cuN^3sS:<W*\u00199\u0016\u0005\r]\u0002\u0003CA~\u0005\u000b\u0011\tl!\u000f\u0011\t\u0005\u001d11H\u0005\u0004\u0007{Y&\u0001C\"pm\u0016\u0014\u0018N\\4\u00029\u001d,w\u000eU1scV,GoQ8mk6t7i\u001c<fe&tw-T1qA\u0005!\u0011N\\5u)\u0011\u0019)ea\u0018\u0011\t\r\u001d3\u0011\f\b\u0005\u0007\u0013\u001a)F\u0004\u0003\u0004L\rMc\u0002BB'\u0007#rAAa\u0006\u0004P%\u0011A,Z\u0005\u0003aFL!A\\8\n\u0007\r]S.\u0001\u0007Xe&$XmU;qa>\u0014H/\u0003\u0003\u0004\\\ru#\u0001D,sSR,7i\u001c8uKb$(bAB,[\"91\u0011\r\u0017A\u0002\r\r\u0014!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0004f\r5TBAB4\u0015\u0011\u0019Iga\u001b\u0002\t\r|gN\u001a\u0006\u0003a\u0016LAaa\u001c\u0004h\ti1i\u001c8gS\u001e,(/\u0019;j_:\fq\u0002\u001d:fa\u0006\u0014XMR8s/JLG/\u001a\u000b\u0005\u0003S\u0019)\bC\u0004\u0002`5\u0002\r!a\u0019\u0002\u001b\u0019Lg.\u00197ju\u0016<&/\u001b;f)\t\u0019Y\b\u0005\u0003\u0004~\r}db\u00017\u0004V%!1\u0011QB/\u0005U1\u0015N\\1mSj,Gm\u0016:ji\u0016\u001cuN\u001c;fqR\fQa\u001e:ji\u0016$B!!\u000b\u0004\b\"11\u0011R\u0018A\u0002Q\f1A]8x\u0003-9(/\u001b;f\r&,G\u000eZ:\u0015\u0011\u0005%2qRBI\u0007'Caa!#1\u0001\u0004!\bbBA\u0018a\u0001\u0007\u00111\u0007\u0005\b\u0007+\u0003\u0004\u0019AA'\u000311\u0017.\u001a7e/JLG/\u001a:t\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0007\u0003'\u001aYj!*\t\u000f\ru\u0015\u00071\u0001\u0004 \u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u00026\r\u0005\u0016\u0002BBR\u0003o\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\n\u0007O\u000b\u0004\u0013!a\u0001\u0007S\u000b1B]8pi>\u0013H-\u001b8bYB1\u0011Q\u0002B~\u0003G\tA#\\1lK^\u0013\u0018\u000e^3sI\u0011,g-Y;mi\u0012\u0012TCABXU\u0011\u0019IK!6\u0002#5\f7.\u001a#fG&l\u0017\r\\,sSR,'\u000f\u0006\u0004\u0002T\rU6\u0011\u0018\u0005\b\u0007o\u001b\u0004\u0019AA\u0012\u0003%\u0001(/Z2jg&|g\u000eC\u0004\u0004<N\u0002\r!a\t\u0002\u000bM\u001c\u0017\r\\3\u0002\u001f5\f7.Z!se\u0006LxK]5uKJ$B!a\u0015\u0004B\"911\u0019\u001bA\u0002\r\u0015\u0017!C1se\u0006LH+\u001f9f!\u0011\t)da2\n\t\r%\u0017q\u0007\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\fQ\"\\1lK6\u000b\u0007o\u0016:ji\u0016\u0014H\u0003BA*\u0007\u001fDqa!56\u0001\u0004\u0019\u0019.A\u0004nCB$\u0016\u0010]3\u0011\t\u0005U2Q[\u0005\u0005\u0007/\f9DA\u0004NCB$\u0016\u0010]3\u0002\u001d\r|gn];nK6+7o]1hKR!\u0011\u0011FBo\u0011!\u0019yN\u000eCA\u0002\r\u0005\u0018!\u00014\u0011\r\u0005511]A\u0015\u0013\u0011\u0019)/a\u0004\u0003\u0011q\u0012\u0017P\\1nKz\nAbY8ogVlWm\u0012:pkB$B!!\u000b\u0004l\"A1q\\\u001c\u0005\u0002\u0004\u0019\t/\u0001\u0007d_:\u001cX/\\3GS\u0016dG\r\u0006\u0004\u0004r\u000eU8\u0011 \u000b\u0005\u0003S\u0019\u0019\u0010\u0003\u0005\u0004`b\"\t\u0019ABq\u0011\u001d\u00199\u0010\u000fa\u0001\u0005c\u000bQAZ5fY\u0012Dqaa?9\u0001\u0004\t\u0019#A\u0003j]\u0012,\u0007\u0010")
public class GeoParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private final scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap;
    private Option<String> geoParquetVersion;
    private Option<JsonAST.JValue> defaultGeoParquetCrs;
    private final scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap;
    private final scala.collection.mutable.Map<String, Covering> geoParquetColumnCoveringMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    private scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap() {
        return this.geometryColumnInfoMap;
    }

    private Option<String> geoParquetVersion() {
        return this.geoParquetVersion;
    }

    private void geoParquetVersion_$eq(Option<String> x$1) {
        this.geoParquetVersion = x$1;
    }

    private Option<JsonAST.JValue> defaultGeoParquetCrs() {
        return this.defaultGeoParquetCrs;
    }

    private void defaultGeoParquetCrs_$eq(Option<JsonAST.JValue> x$1) {
        this.defaultGeoParquetCrs = x$1;
    }

    private scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap() {
        return this.geoParquetColumnCrsMap;
    }

    private scala.collection.mutable.Map<String, Covering> geoParquetColumnCoveringMap() {
        return this.geoParquetColumnCoveringMap;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        Some some;
        Some some2;
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.schema().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                return this.makeWriter(field.dataType(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)ordinal)));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        if (this.geometryColumnInfoMap().isEmpty()) {
            throw new RuntimeException("No geometry column found in the schema");
        }
        String string = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_VERSION_KEY());
        if (string == null) {
            some2 = new Some((Object)GeoParquetMetaData$.MODULE$.VERSION());
        } else if (string != null) {
            String string2 = string;
            some2 = new Some((Object)string2);
        } else {
            throw new MatchError((Object)string);
        }
        this.geoParquetVersion_$eq((Option<String>)some2);
        String string3 = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY());
        if (string3 == null) {
            some = new Some((Object)org.json4s.package$.MODULE$.JNull());
        } else if ("".equals(string3)) {
            some = None$.MODULE$;
        } else if (string3 != null) {
            String string4 = string3;
            some = new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string4), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        } else {
            throw new MatchError((Object)string3);
        }
        this.defaultGeoParquetCrs_$eq((Option<JsonAST.JValue>)some);
        ((IterableOnceOps)this.geometryColumnInfoMap().keys().map((Function1 & Serializable)x$6 -> GeoParquetWriteSupport.$anonfun$init$2(this, BoxesRunTime.unboxToInt((Object)x$6)))).foreach((Function1 & Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$3(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY())).foreach((Function1 & Serializable)coveringColumnName -> {
            if (this.geometryColumnInfoMap().size() > 1) {
                throw new IllegalArgumentException(new StringBuilder(115).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(" is ambiguous when there are multiple geometry columns.").append("Please specify ").append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(".<columnName> for configured geometry column.").toString());
            }
            String geometryColumnName = this.schema().apply(BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head())).name();
            Covering covering = GeoParquetMetaData$.MODULE$.createCoveringColumnMetadata((String)coveringColumnName, this.schema());
            return this.geoParquetColumnCoveringMap().put((Object)geometryColumnName, (Object)covering);
        });
        ((IterableOnceOps)this.geometryColumnInfoMap().keys().map((Function1 & Serializable)x$7 -> GeoParquetWriteSupport.$anonfun$init$6(this, BoxesRunTime.unboxToInt((Object)x$7)))).foreach((Function1 & Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$7(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        String sparkSqlParquetRowMetadata = GeoParquetWriteSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetWriteSupport$$getSparkSqlParquetRowMetadata(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)sparkSqlParquetRowMetadata)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyDateTime"), (Object)"")) : None$.MODULE$))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyINT96"), (Object)"")) : None$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())));
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Object object;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.geometryColumnInfoMap().nonEmpty()) {
            int primaryColumnIndex = BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head());
            String primaryColumn = this.schema().fields()[primaryColumnIndex].name();
            scala.collection.immutable.Map columns = this.geometryColumnInfoMap().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int ordinal = tuple2._1$mcI$sp();
                    GeometryColumnInfo columnInfo = (GeometryColumnInfo)tuple2._2();
                    String columnName = this.schema().fields()[ordinal].name();
                    Seq geometryTypes = columnInfo.seenGeometryTypes().toSeq();
                    Seq bbox = geometryTypes.nonEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{columnInfo.bbox().minX(), columnInfo.bbox().minY(), columnInfo.bbox().maxX(), columnInfo.bbox().maxY()})) : (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}));
                    Option crs = (Option)this.geoParquetColumnCrsMap().getOrElse((Object)columnName, (Function0 & Serializable)() -> this.defaultGeoParquetCrs());
                    Option covering = this.geoParquetColumnCoveringMap().get((Object)columnName);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)crs, (Option<Covering>)covering));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            GeoParquetMetaData geoParquetMetadata = new GeoParquetMetaData(this.geoParquetVersion(), primaryColumn, (scala.collection.immutable.Map<String, GeometryFieldMetaData>)columns);
            String geoParquetMetadataJson = GeoParquetMetaData$.MODULE$.toJson(geoParquetMetadata);
            object = metadata.put("geo", geoParquetMetadataJson);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new WriteSupport.FinalizedWriteContext(metadata);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, Option<Object> rootOrdinal) {
        while (true) {
            DecimalType decimalType;
            Option option;
            DataType dataType2;
            if (BooleanType$.MODULE$.equals(dataType2 = dataType)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                Enumeration.Value value = this.outputTimestampType();
                Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                throw new MatchError((Object)value);
            }
            if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$14(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                return this.makeDecimalWriter(precision, scale);
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$9 -> x$9.dataType())).map((Function1 & Serializable)x$10 -> this.makeWriter((DataType)x$10, (Option<Object>)None$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return this.makeArrayWriter(arrayType);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return this.makeMapWriter(mapType);
            }
            if (((Object)((Object)GeometryUDT$.MODULE$)).equals(dataType2)) {
                GeometryColumnInfo geometryColumnInfo;
                Option<Object> option2 = rootOrdinal;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int ordinal2 = BoxesRunTime.unboxToInt((Object)some.value());
                    geometryColumnInfo = (GeometryColumnInfo)this.geometryColumnInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ordinal2), (Function0 & Serializable)() -> new GeometryColumnInfo());
                } else if (None$.MODULE$.equals(option2)) {
                    geometryColumnInfo = null;
                } else {
                    throw new MatchError(option2);
                }
                GeometryColumnInfo geometryColumnInfo2 = geometryColumnInfo;
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$20(this, geometryColumnInfo2, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            rootOrdinal = this.makeWriter$default$2();
            dataType = userDefinedType.sqlType();
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType).append(".").toString());
    }

    private Option<Object> makeWriter$default$2() {
        return None$.MODULE$;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (bl3 && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return binaryWriterUsingUnscaledLong;
        }
        return binaryWriterUsingUnscaledBytes;
    }

    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), this.makeWriter$default$2());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                return this.twoLevelArrayWriter$1("array", elementWriter);
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), this.makeWriter$default$2());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), this.makeWriter$default$2());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ String $anonfun$init$2(GeoParquetWriteSupport $this, int x$6) {
        return $this.schema().apply(x$6).name();
    }

    public static final /* synthetic */ void $anonfun$init$3(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable)x0$2 -> {
            String string = x0$2;
            if ("".equals(string)) {
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)None$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
            }
            throw new MatchError((Object)string);
        });
    }

    public static final /* synthetic */ String $anonfun$init$6(GeoParquetWriteSupport $this, int x$7) {
        return $this.schema().apply(x$7).name();
    }

    public static final /* synthetic */ void $anonfun$init$7(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_COVERING_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable)coveringColumnName -> {
            Covering covering = GeoParquetMetaData$.MODULE$.createCoveringColumnMetadata((String)coveringColumnName, $this.schema());
            return $this.geoParquetColumnCoveringMap().put((Object)name, (Object)covering);
        });
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        int julianDay2 = sp2._1$mcI$sp();
        long timeOfDayNanos2 = sp2._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$20(GeoParquetWriteSupport $this, GeometryColumnInfo geometryColumnInfo$1, SpecializedGetters row, int ordinal) {
        byte[] serializedGeometry = row.getBinary(ordinal);
        Geometry geom = GeometryUDT$.MODULE$.deserialize(serializedGeometry);
        WKBWriter wkbWriter = new WKBWriter(GeomUtils.getDimension(geom));
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])wkbWriter.write(geom)));
        if (geometryColumnInfo$1 != null) {
            geometryColumnInfo$1.update(geom);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (!array.isNullAt(i$2.elem)) {
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(GeoParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
                return;
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (map.numElements() > 0) {
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            if (!map.valueArray().isNullAt(i$3.elem)) {
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    public GeoParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
        this.geometryColumnInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.geoParquetVersion = None$.MODULE$;
        this.defaultGeoParquetCrs = None$.MODULE$;
        this.geoParquetColumnCrsMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.geoParquetColumnCoveringMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static class GeometryColumnBoundingBox {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        public double minX() {
            return this.minX;
        }

        public void minX_$eq(double x$1) {
            this.minX = x$1;
        }

        public double minY() {
            return this.minY;
        }

        public void minY_$eq(double x$1) {
            this.minY = x$1;
        }

        public double maxX() {
            return this.maxX;
        }

        public void maxX_$eq(double x$1) {
            this.maxX = x$1;
        }

        public double maxY() {
            return this.maxY;
        }

        public void maxY_$eq(double x$1) {
            this.maxY = x$1;
        }

        public void update(Geometry geom) {
            Envelope env = geom.getEnvelopeInternal();
            this.minX_$eq(scala.math.package$.MODULE$.min(this.minX(), env.getMinX()));
            this.minY_$eq(scala.math.package$.MODULE$.min(this.minY(), env.getMinY()));
            this.maxX_$eq(scala.math.package$.MODULE$.max(this.maxX(), env.getMaxX()));
            this.maxY_$eq(scala.math.package$.MODULE$.max(this.maxY(), env.getMaxY()));
        }

        public GeometryColumnBoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    public static class GeometryColumnInfo {
        private final GeometryColumnBoundingBox bbox = new GeometryColumnBoundingBox(GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$1(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$2(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$3(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$4());
        private final Set<String> seenGeometryTypes = (Set)Set$.MODULE$.empty();

        public GeometryColumnBoundingBox bbox() {
            return this.bbox;
        }

        public Set<String> seenGeometryTypes() {
            return this.seenGeometryTypes;
        }

        public void update(Geometry geom) {
            this.bbox().update(geom);
            Coordinate coordinate = geom.getCoordinate();
            boolean hasZ = coordinate != null ? !Double.isNaN(coordinate.getZ()) : false;
            String geometryType = !hasZ ? geom.getGeometryType() : new StringBuilder(2).append(geom.getGeometryType()).append(" Z").toString();
            this.seenGeometryTypes().add((Object)geometryType);
        }
    }
}

