/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo;

import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorFactory;
import org.apache.servicecomb.swagger.generator.pojo.PojoSwaggerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoSwaggerGeneratorFactory
implements SwaggerGeneratorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoSwaggerGeneratorFactory.class);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean canProcess(Class<?> cls) {
        for (Annotation annotation : cls.getAnnotations()) {
            if (!(annotation instanceof Path) && !"org.springframework.web.bind.annotation.RequestMapping".equals(annotation.annotationType().getCanonicalName())) continue;
            LOGGER.info("There is @RequestMapping or @Path annotation on the REST interface class, but POJO swagger generator is chosen. If this is unexpected, maybe you should check your dependency jar files.");
        }
        return true;
    }

    @Override
    public SwaggerGenerator create(Class<?> cls) {
        return new PojoSwaggerGenerator(cls);
    }
}

