/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementGroupConfig;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.TagFinder;

public class MeasurementTree
extends MeasurementNode {
    public MeasurementTree() {
        super(null, null, null);
    }

    public void from(Iterator<Meter> meters, MeasurementGroupConfig groupConfig) {
        meters.forEachRemaining(meter -> {
            if (meter instanceof DistributionSummary) {
                DistributionSummary distributionSummary = (DistributionSummary)meter;
                HistogramSnapshot snapshot = distributionSummary.takeSnapshot();
                CountAtBucket[] countAtBuckets = snapshot.histogramCounts();
                ArrayList<Measurement> distributions = new ArrayList<Measurement>(countAtBuckets.length);
                for (CountAtBucket countAtBucket : countAtBuckets) {
                    double value = countAtBucket.count();
                    distributions.add(new Measurement(() -> value, Statistic.COUNT));
                }
                this.from(meter.getId(), distributions, groupConfig);
                return;
            }
            Iterable measurements = meter.measure();
            this.from(meter.getId(), measurements, groupConfig);
        });
    }

    public void from(Meter.Id id, Iterable<Measurement> measurements, MeasurementGroupConfig groupConfig) {
        for (Measurement measurement : measurements) {
            MeasurementNode node = this.addChild(id.getName(), id, measurement);
            List<TagFinder> tagFinders = groupConfig.findTagFinders(id.getName());
            if (tagFinders == null) continue;
            for (TagFinder tagFinder : tagFinders) {
                Tag tag = tagFinder.find(id.getTags());
                if (tag == null) {
                    if (tagFinder.skipOnNull()) break;
                    throw new IllegalStateException(String.format("tag key \"%s\" not exist in %s", tagFinder.getTagKey(), id));
                }
                node = node.addChild(tag.getValue(), id, measurement);
            }
            node.addChild(measurement.getStatistic().name(), id, measurement);
        }
    }
}

