/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.concurrent;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.context.Reloadable;
import org.apache.shardingsphere.elasticjob.infra.context.ReloadablePostProcessor;
import org.apache.shardingsphere.elasticjob.infra.handler.threadpool.JobExecutorServiceHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceReloadable
implements Reloadable<ExecutorService>,
ReloadablePostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceReloadable.class);
    private String jobExecutorServiceHandlerType;
    private ExecutorService executorService;

    @Override
    public void init(JobConfiguration jobConfig) {
        this.jobExecutorServiceHandlerType = Strings.isNullOrEmpty((String)jobConfig.getJobExecutorServiceHandlerType()) ? "CPU" : jobConfig.getJobExecutorServiceHandlerType();
        this.executorService = JobExecutorServiceHandlerFactory.getHandler(this.jobExecutorServiceHandlerType).createExecutorService(jobConfig.getJobName());
    }

    @Override
    public synchronized void reloadIfNecessary(JobConfiguration jobConfig) {
        String newJobExecutorServiceHandlerType;
        String string = newJobExecutorServiceHandlerType = Strings.isNullOrEmpty((String)jobConfig.getJobExecutorServiceHandlerType()) ? "CPU" : jobConfig.getJobExecutorServiceHandlerType();
        if (newJobExecutorServiceHandlerType.equals(this.jobExecutorServiceHandlerType)) {
            return;
        }
        log.debug("JobExecutorServiceHandler reload occurred in the job '{}'. Change from '{}' to '{}'.", new Object[]{jobConfig.getJobName(), this.jobExecutorServiceHandlerType, newJobExecutorServiceHandlerType});
        this.reload(newJobExecutorServiceHandlerType, jobConfig.getJobName());
    }

    private void reload(String jobExecutorServiceHandlerType, String jobName) {
        this.executorService.shutdown();
        this.jobExecutorServiceHandlerType = jobExecutorServiceHandlerType;
        this.executorService = JobExecutorServiceHandlerFactory.getHandler(jobExecutorServiceHandlerType).createExecutorService(jobName);
    }

    @Override
    public ExecutorService getInstance() {
        return this.executorService;
    }

    @Override
    public void close() {
        Optional.ofNullable(this.executorService).ifPresent(ExecutorService::shutdown);
    }

    @Override
    public String getType() {
        return ExecutorService.class.getName();
    }
}

