/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.controller;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Optional;
import org.apache.mesos.Protos;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.CloudAppConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.exception.AppConfigurationException;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app.DisableAppService;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.annotation.ContextPath;
import org.apache.shardingsphere.elasticjob.restful.annotation.Mapping;
import org.apache.shardingsphere.elasticjob.restful.annotation.Param;
import org.apache.shardingsphere.elasticjob.restful.annotation.ParamSource;
import org.apache.shardingsphere.elasticjob.restful.annotation.RequestBody;

@ContextPath(value="/api/app")
public final class CloudAppController
implements RestfulController {
    private static CoordinatorRegistryCenter regCenter;
    private static ProducerManager producerManager;
    private final CloudAppConfigurationService appConfigService = new CloudAppConfigurationService(regCenter);
    private final CloudJobConfigurationService jobConfigService = new CloudJobConfigurationService(regCenter);
    private final DisableAppService disableAppService;
    private final MesosStateService mesosStateService = new MesosStateService(regCenter);

    public CloudAppController() {
        this.disableAppService = new DisableAppService(regCenter);
    }

    public static void init(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        CloudAppController.regCenter = regCenter;
        CloudAppController.producerManager = producerManager;
    }

    @Mapping(method="POST")
    public boolean register(@RequestBody CloudAppConfigurationPOJO appConfig) {
        Optional<CloudAppConfigurationPOJO> appConfigFromZk = this.appConfigService.load(appConfig.getAppName());
        if (appConfigFromZk.isPresent()) {
            throw new AppConfigurationException("app '%s' already existed.", appConfig.getAppName());
        }
        this.appConfigService.add(appConfig);
        return true;
    }

    @Mapping(method="PUT")
    public boolean update(@RequestBody CloudAppConfigurationPOJO appConfig) {
        this.appConfigService.update(appConfig);
        return true;
    }

    @Mapping(method="GET", path="/{appName}")
    public CloudAppConfigurationPOJO detail(@Param(name="appName", source=ParamSource.PATH) String appName) {
        Optional<CloudAppConfigurationPOJO> appConfig = this.appConfigService.load(appName);
        return appConfig.orElse(null);
    }

    @Mapping(method="GET", path="/list")
    public Collection<CloudAppConfigurationPOJO> findAllApps() {
        return this.appConfigService.loadAll();
    }

    @Mapping(method="GET", path="/{appName}/disable")
    public boolean isDisabled(@Param(name="appName", source=ParamSource.PATH) String appName) {
        return this.disableAppService.isDisabled(appName);
    }

    @Mapping(method="POST", path="/{appName}/disable")
    public boolean disable(@Param(name="appName", source=ParamSource.PATH) String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.disableAppService.add(appName);
            for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
                if (!appName.equals(each.getAppName())) continue;
                producerManager.unschedule(each.getJobName());
            }
        }
        return true;
    }

    @Mapping(method="POST", path="/{appName}/enable")
    public boolean enable(@Param(name="appName", source=ParamSource.PATH) String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.disableAppService.remove(appName);
            for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
                if (!appName.equals(each.getAppName())) continue;
                producerManager.reschedule(each.getJobName());
            }
        }
        return true;
    }

    @Mapping(method="DELETE", path="/{appName}")
    public boolean deregister(@Param(name="appName", source=ParamSource.PATH) String appName) {
        if (this.appConfigService.load(appName).isPresent()) {
            this.removeAppAndJobConfigurations(appName);
            this.stopExecutors(appName);
        }
        return true;
    }

    private void removeAppAndJobConfigurations(String appName) {
        for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
            if (!appName.equals(each.getAppName())) continue;
            producerManager.deregister(each.getJobName());
        }
        this.disableAppService.remove(appName);
        this.appConfigService.remove(appName);
    }

    private void stopExecutors(String appName) {
        try {
            Collection<MesosStateService.ExecutorStateInfo> executorBriefInfo = this.mesosStateService.executors(appName);
            for (MesosStateService.ExecutorStateInfo each : executorBriefInfo) {
                producerManager.sendFrameworkMessage(Protos.ExecutorID.newBuilder().setValue(each.getId()).build(), Protos.SlaveID.newBuilder().setValue(each.getSlaveId()).build(), "STOP".getBytes());
            }
        }
        catch (JsonParseException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }
}

