/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VirtualMachineCurrentState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.mesos.Protos;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppConstraintEvaluator
implements ConstraintEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppConstraintEvaluator.class);
    private static AppConstraintEvaluator instance;
    private final Set<String> runningApps = new HashSet<String>();
    private final FacadeService facadeService;

    public static void init(FacadeService facadeService) {
        instance = new AppConstraintEvaluator(facadeService);
    }

    static AppConstraintEvaluator getInstance() {
        return (AppConstraintEvaluator)Preconditions.checkNotNull((Object)instance);
    }

    void loadAppRunningState() {
        try {
            for (MesosStateService.ExecutorStateInfo each : this.facadeService.loadExecutorInfo()) {
                this.runningApps.add(each.getId());
            }
        }
        catch (JsonParseException e) {
            this.clearAppRunningState();
        }
    }

    void clearAppRunningState() {
        this.runningApps.clear();
    }

    public String getName() {
        return "App-Fitness-Calculator";
    }

    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        double assigningCpus = 0.0;
        double assigningMemoryMB = 0.0;
        String slaveId = ((Protos.Offer)targetVM.getAllCurrentOffers().iterator().next()).getSlaveId().getValue();
        try {
            if (this.isAppRunningOnSlave(taskRequest.getId(), slaveId)) {
                return new ConstraintEvaluator.Result(true, "");
            }
            HashSet<String> calculatedApps = new HashSet<String>();
            ArrayList<TaskRequest> taskRequests = new ArrayList<TaskRequest>(targetVM.getTasksCurrentlyAssigned().size() + 1);
            taskRequests.add(taskRequest);
            for (TaskAssignmentResult taskAssignmentResult : targetVM.getTasksCurrentlyAssigned()) {
                taskRequests.add(taskAssignmentResult.getRequest());
            }
            for (TaskRequest taskRequest2 : taskRequests) {
                CloudAppConfigurationPOJO assigningAppConfig;
                assigningCpus += taskRequest2.getCPUs();
                assigningMemoryMB += taskRequest2.getMemory();
                if (this.isAppRunningOnSlave(taskRequest2.getId(), slaveId) || !calculatedApps.add((assigningAppConfig = this.getAppConfiguration(taskRequest2.getId())).getAppName())) continue;
                assigningCpus += assigningAppConfig.getCpuCount();
                assigningMemoryMB += assigningAppConfig.getMemoryMB();
            }
        }
        catch (LackConfigException ex) {
            log.warn("Lack config, disable {}", (Object)this.getName(), (Object)ex);
            return new ConstraintEvaluator.Result(true, "");
        }
        if (assigningCpus > targetVM.getCurrAvailableResources().cpuCores()) {
            log.debug("Failure {} {} cpus:{}/{}", new Object[]{taskRequest.getId(), slaveId, assigningCpus, targetVM.getCurrAvailableResources().cpuCores()});
            return new ConstraintEvaluator.Result(false, String.format("cpu:%s/%s", assigningCpus, targetVM.getCurrAvailableResources().cpuCores()));
        }
        if (assigningMemoryMB > targetVM.getCurrAvailableResources().memoryMB()) {
            log.debug("Failure {} {} mem:{}/{}", new Object[]{taskRequest.getId(), slaveId, assigningMemoryMB, targetVM.getCurrAvailableResources().memoryMB()});
            return new ConstraintEvaluator.Result(false, String.format("mem:%s/%s", assigningMemoryMB, targetVM.getCurrAvailableResources().memoryMB()));
        }
        log.debug("Success {} {} cpus:{}/{} mem:{}/{}", new Object[]{taskRequest.getId(), slaveId, assigningCpus, targetVM.getCurrAvailableResources().cpuCores(), assigningMemoryMB, targetVM.getCurrAvailableResources().memoryMB()});
        return new ConstraintEvaluator.Result(true, String.format("cpus:%s/%s mem:%s/%s", assigningCpus, targetVM.getCurrAvailableResources().cpuCores(), assigningMemoryMB, targetVM.getCurrAvailableResources().memoryMB()));
    }

    private boolean isAppRunningOnSlave(String taskId, String slaveId) throws LackConfigException {
        TaskContext taskContext = TaskContext.from((String)taskId);
        taskContext.setSlaveId(slaveId);
        return this.runningApps.contains(taskContext.getExecutorId(this.getJobConfiguration(taskContext).getAppName()));
    }

    private CloudAppConfigurationPOJO getAppConfiguration(String taskId) throws LackConfigException {
        CloudJobConfiguration cloudJobConfig = this.getJobConfiguration(TaskContext.from((String)taskId));
        Optional<CloudAppConfigurationPOJO> appConfigOptional = this.facadeService.loadAppConfig(cloudJobConfig.getAppName());
        if (!appConfigOptional.isPresent()) {
            throw new LackConfigException("APP", cloudJobConfig.getAppName());
        }
        return appConfigOptional.get();
    }

    private CloudJobConfiguration getJobConfiguration(TaskContext taskContext) throws LackConfigException {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.facadeService.load(taskContext.getMetaInfo().getJobName());
        if (!cloudJobConfig.isPresent()) {
            throw new LackConfigException("JOB", taskContext.getMetaInfo().getJobName());
        }
        return cloudJobConfig.get().toCloudJobConfiguration();
    }

    @Generated
    private AppConstraintEvaluator(FacadeService facadeService) {
        this.facadeService = facadeService;
    }

    private static class LackConfigException
    extends Exception {
        private static final long serialVersionUID = -3340824363577154813L;

        LackConfigException(String scope, String configName) {
            super(String.format("Lack %s's config %s", scope, configName));
        }
    }
}

