/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.ha.FrameworkIDService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.util.HttpClientUtils;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesosStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MesosStateService.class);
    private static String stateUrl;
    private final FrameworkIDService frameworkIDService;

    public MesosStateService(CoordinatorRegistryCenter regCenter) {
        this.frameworkIDService = new FrameworkIDService(regCenter);
    }

    public static synchronized void register(String hostName, int port) {
        stateUrl = String.format("http://%s:%d/state", hostName, port);
    }

    public static synchronized void deregister() {
        stateUrl = null;
    }

    public Collection<Map<String, String>> sandbox(String appName) throws JsonParseException {
        JsonObject state = this.fetch(stateUrl);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (JsonObject each : this.findExecutors(state.getAsJsonArray("frameworks"), appName)) {
            JsonArray slaves = state.get("slaves").getAsJsonArray();
            String slaveHost = null;
            for (int i = 0; i < slaves.size(); ++i) {
                JsonObject slave = slaves.get(i).getAsJsonObject();
                if (!each.get("slave_id").getAsString().equals(slave.get("id").getAsString())) continue;
                slaveHost = slave.get("pid").getAsString().split("@")[1];
            }
            Preconditions.checkNotNull(slaveHost);
            JsonObject slaveState = this.fetch(String.format("http://%s/state", slaveHost));
            String workDir = slaveState.get("flags").getAsJsonObject().get("work_dir").getAsString();
            Collection<JsonObject> executorsOnSlave = this.findExecutors(slaveState.get("frameworks").getAsJsonArray(), appName);
            for (JsonObject executorOnSlave : executorsOnSlave) {
                LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
                r.put("hostname", slaveState.get("hostname").getAsString());
                r.put("path", executorOnSlave.get("directory").getAsString().replace(workDir, ""));
                result.add(r);
            }
        }
        return result;
    }

    public Collection<ExecutorStateInfo> executors(String appName) throws JsonParseException {
        return this.findExecutors(this.fetch(stateUrl).get("frameworks").getAsJsonArray(), appName).stream().map(each -> {
            try {
                return ExecutorStateInfo.builder().id(this.getExecutorId((JsonObject)each)).slaveId(each.get("slave_id").getAsString()).build();
            }
            catch (JsonParseException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList());
    }

    public Collection<ExecutorStateInfo> executors() throws JsonParseException {
        return this.executors(null);
    }

    private JsonObject fetch(String url) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        return GsonFactory.getJsonParser().parse(HttpClientUtils.httpGet(url).getContent()).getAsJsonObject();
    }

    private Collection<JsonObject> findExecutors(JsonArray frameworks, String appName) throws JsonParseException {
        Optional<String> frameworkIDOptional = this.frameworkIDService.fetch();
        if (!frameworkIDOptional.isPresent()) {
            return Collections.emptyList();
        }
        String frameworkID = frameworkIDOptional.get();
        LinkedList<JsonObject> result = new LinkedList<JsonObject>();
        for (int i = 0; i < frameworks.size(); ++i) {
            JsonObject framework = frameworks.get(i).getAsJsonObject();
            if (!framework.get("id").getAsString().equals(frameworkID)) continue;
            JsonArray executors = framework.get("executors").getAsJsonArray();
            for (int j = 0; j < executors.size(); ++j) {
                JsonObject executor = executors.get(j).getAsJsonObject();
                if (null != appName && !appName.equals(this.getExecutorId(executor).split("@-@")[0])) continue;
                result.add(executor);
            }
        }
        return result;
    }

    private String getExecutorId(JsonObject executor) throws JsonParseException {
        return executor.has("id") ? executor.get("id").getAsString() : executor.get("executor_id").getAsString();
    }

    public static final class ExecutorStateInfo {
        private final String id;
        private final String slaveId;

        @Generated
        ExecutorStateInfo(String id, String slaveId) {
            this.id = id;
            this.slaveId = slaveId;
        }

        @Generated
        public static ExecutorStateInfoBuilder builder() {
            return new ExecutorStateInfoBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getSlaveId() {
            return this.slaveId;
        }

        @Generated
        public static class ExecutorStateInfoBuilder {
            @Generated
            private String id;
            @Generated
            private String slaveId;

            @Generated
            ExecutorStateInfoBuilder() {
            }

            @Generated
            public ExecutorStateInfoBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ExecutorStateInfoBuilder slaveId(String slaveId) {
                this.slaveId = slaveId;
                return this;
            }

            @Generated
            public ExecutorStateInfo build() {
                return new ExecutorStateInfo(this.id, this.slaveId);
            }

            @Generated
            public String toString() {
                return "MesosStateService.ExecutorStateInfo.ExecutorStateInfoBuilder(id=" + this.id + ", slaveId=" + this.slaveId + ")";
            }
        }
    }
}

