/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.producer;

import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.TransientProducerRepository;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready.ReadyService;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.simpl.SimpleThreadPool;

final class TransientProducerScheduler {
    private final TransientProducerRepository repository = new TransientProducerRepository();
    private final ReadyService readyService;
    private Scheduler scheduler;

    TransientProducerScheduler(ReadyService readyService) {
        this.readyService = readyService;
    }

    void start() {
        this.scheduler = this.getScheduler();
        try {
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private Scheduler getScheduler() {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        try {
            factory.initialize(this.getQuartzProperties());
            return factory.getScheduler();
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private Properties getQuartzProperties() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", Integer.toString(Runtime.getRuntime().availableProcessors() * 2));
        result.put("org.quartz.scheduler.instanceName", "ELASTIC_JOB_CLOUD_TRANSIENT_PRODUCER");
        result.put("org.quartz.plugin.shutdownhook.class", ShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    synchronized void register(CloudJobConfigurationPOJO cloudJobConfig) {
        String cron = cloudJobConfig.getCron();
        JobKey jobKey = this.buildJobKey(cron);
        this.repository.put(jobKey, cloudJobConfig.getJobName());
        try {
            if (!this.scheduler.checkExists(jobKey)) {
                this.scheduler.scheduleJob(this.buildJobDetail(jobKey), this.buildTrigger(jobKey.getName()));
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private JobDetail buildJobDetail(JobKey jobKey) {
        JobDetail result = JobBuilder.newJob(ProducerJob.class).withIdentity(jobKey).build();
        result.getJobDataMap().put("repository", (Object)this.repository);
        result.getJobDataMap().put("readyService", (Object)this.readyService);
        return result;
    }

    private Trigger buildTrigger(String cron) {
        return TriggerBuilder.newTrigger().withIdentity(cron).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing()).build();
    }

    synchronized void deregister(CloudJobConfigurationPOJO cloudJobConfig) {
        this.repository.remove(cloudJobConfig.getJobName());
        String cron = cloudJobConfig.getCron();
        if (!this.repository.containsKey(this.buildJobKey(cron))) {
            try {
                this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)cron));
            }
            catch (SchedulerException ex) {
                throw new JobSystemException((Throwable)ex);
            }
        }
    }

    private JobKey buildJobKey(String cron) {
        return JobKey.jobKey((String)cron);
    }

    void shutdown() {
        try {
            if (null != this.scheduler && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
        this.repository.removeAll();
    }

    public static final class ProducerJob
    implements Job {
        private TransientProducerRepository repository;
        private ReadyService readyService;

        public void execute(JobExecutionContext context) {
            List<String> jobNames = this.repository.get(context.getJobDetail().getKey());
            for (String each : jobNames) {
                this.readyService.addTransient(each);
            }
        }

        @Generated
        public void setRepository(TransientProducerRepository repository) {
            this.repository = repository;
        }

        @Generated
        public void setReadyService(ReadyService readyService) {
            this.readyService = readyService;
        }
    }
}

