/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.context.JobContext;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready.ReadyNode;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadyService.class);
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();
    private final CoordinatorRegistryCenter regCenter;
    private final CloudJobConfigurationService configService;
    private final RunningService runningService;

    public ReadyService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
        this.configService = new CloudJobConfigurationService(regCenter);
        this.runningService = new RunningService(regCenter);
    }

    public void addTransient(String jobName) {
        if (this.regCenter.getNumChildren("/state/ready") > this.env.getFrameworkConfiguration().getJobStateQueueSize()) {
            log.warn("Cannot add transient job, caused by read state queue size is larger than {}.", (Object)this.env.getFrameworkConfiguration().getJobStateQueueSize());
            return;
        }
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(jobName);
        if (!cloudJobConfig.isPresent() || CloudJobExecutionType.TRANSIENT != cloudJobConfig.get().getJobExecutionType()) {
            return;
        }
        String readyJobNode = ReadyNode.getReadyJobNodePath(jobName);
        String times = this.regCenter.getDirectly(readyJobNode);
        if (cloudJobConfig.get().isMisfire()) {
            this.regCenter.persist(readyJobNode, Integer.toString(null == times ? 1 : Integer.parseInt(times) + 1));
        } else {
            this.regCenter.persist(ReadyNode.getReadyJobNodePath(jobName), "1");
        }
    }

    public void addDaemon(String jobName) {
        if (this.regCenter.getNumChildren("/state/ready") > this.env.getFrameworkConfiguration().getJobStateQueueSize()) {
            log.warn("Cannot add daemon job, caused by read state queue size is larger than {}.", (Object)this.env.getFrameworkConfiguration().getJobStateQueueSize());
            return;
        }
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(jobName);
        if (!cloudJobConfig.isPresent() || CloudJobExecutionType.DAEMON != cloudJobConfig.get().getJobExecutionType() || this.runningService.isJobRunning(jobName)) {
            return;
        }
        this.regCenter.persist(ReadyNode.getReadyJobNodePath(jobName), "1");
    }

    public void setMisfireDisabled(String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(jobName);
        if (cloudJobConfig.isPresent() && null != this.regCenter.getDirectly(ReadyNode.getReadyJobNodePath(jobName))) {
            this.regCenter.persist(ReadyNode.getReadyJobNodePath(jobName), "1");
        }
    }

    public Collection<JobContext> getAllEligibleJobContexts(Collection<JobContext> ineligibleJobContexts) {
        if (!this.regCenter.isExisted("/state/ready")) {
            return Collections.emptyList();
        }
        Collection ineligibleJobNames = ineligibleJobContexts.stream().map(input -> input.getCloudJobConfig().getJobConfig().getJobName()).collect(Collectors.toList());
        List jobNames = this.regCenter.getChildrenKeys("/state/ready");
        ArrayList<JobContext> result = new ArrayList<JobContext>(jobNames.size());
        for (String each : jobNames) {
            if (ineligibleJobNames.contains(each)) continue;
            Optional<CloudJobConfigurationPOJO> jobConfig = this.configService.load(each);
            if (!jobConfig.isPresent()) {
                this.regCenter.remove(ReadyNode.getReadyJobNodePath(each));
                continue;
            }
            if (this.runningService.isJobRunning(each)) continue;
            result.add(JobContext.from(jobConfig.get().toCloudJobConfiguration(), ExecutionType.READY));
        }
        return result;
    }

    public void remove(Collection<String> jobNames) {
        for (String each : jobNames) {
            int times;
            String readyJobNode = ReadyNode.getReadyJobNodePath(each);
            String timesStr = this.regCenter.getDirectly(readyJobNode);
            int n = times = null == timesStr ? 0 : Integer.parseInt(timesStr);
            if (times <= 1) {
                this.regCenter.remove(readyJobNode);
                continue;
            }
            this.regCenter.persist(readyJobNode, Integer.toString(times - 1));
        }
    }

    public Map<String, Integer> getAllReadyTasks() {
        if (!this.regCenter.isExisted("/state/ready")) {
            return Collections.emptyMap();
        }
        List jobNames = this.regCenter.getChildrenKeys("/state/ready");
        HashMap<String, Integer> result = new HashMap<String, Integer>(jobNames.size(), 1.0f);
        for (String each : jobNames) {
            String times = this.regCenter.get(ReadyNode.getReadyJobNodePath(each));
            if (Strings.isNullOrEmpty((String)times)) continue;
            result.put(each, Integer.parseInt(times));
        }
        return result;
    }
}

