/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.sharding;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobShardingStrategy;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;

public final class JobShardingStrategyFactory {
    private static final String DEFAULT_STRATEGY = "AVG_ALLOCATION";

    public static JobShardingStrategy getStrategy(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return ElasticJobServiceLoader.getCachedTypedServiceInstance(JobShardingStrategy.class, DEFAULT_STRATEGY).get();
        }
        return ElasticJobServiceLoader.getCachedTypedServiceInstance(JobShardingStrategy.class, type).orElseThrow(() -> new JobConfigurationException("Cannot find sharding strategy using type '%s'.", type));
    }

    @Generated
    private JobShardingStrategyFactory() {
    }

    static {
        ElasticJobServiceLoader.registerTypedService(JobShardingStrategy.class);
    }
}

