/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues;

import com.netflix.fenzo.AssignmentFailure;

public class Assignable<T> {
    private final T task;
    private final AssignmentFailure assignmentFailure;

    private Assignable(T task, AssignmentFailure assignmentFailure) {
        this.task = task;
        this.assignmentFailure = assignmentFailure;
    }

    public T getTask() {
        return this.task;
    }

    public boolean hasFailure() {
        return this.assignmentFailure != null;
    }

    public AssignmentFailure getAssignmentFailure() {
        return this.assignmentFailure;
    }

    public static <T> Assignable<T> success(T task) {
        return new Assignable<T>(task, null);
    }

    public static <T> Assignable<T> error(T task, AssignmentFailure assignmentFailure) {
        return new Assignable<T>(task, assignmentFailure);
    }
}

