/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.queues.Assignable;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.queues.tiered.QueueBucket;
import com.netflix.fenzo.queues.tiered.SortedBuckets;
import com.netflix.fenzo.queues.tiered.TierSla;
import com.netflix.fenzo.sla.ResAllocs;
import com.netflix.fenzo.sla.ResAllocsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Tier
implements UsageTrackedQueue {
    private static final Logger logger = LoggerFactory.getLogger(Tier.class);
    private final int tierNumber;
    private final String tierName;
    private TierSla tierSla;
    private final UsageTrackedQueue.ResUsage totals;
    private ResAllocs tierResources = null;
    private ResAllocs effectiveUsedResources;
    private ResAllocs remainingResources = null;
    private final Map<String, ResAllocs> lastEffectiveUsedResources = new HashMap<String, ResAllocs>();
    private final SortedBuckets sortedBuckets;
    private Map<VMResource, Double> currTotalResourcesMap = new HashMap<VMResource, Double>();
    private final BiFunction<Integer, String, Double> allocsShareGetter;

    Tier(int tierNumber, BiFunction<Integer, String, Double> allocsShareGetter) {
        this.tierNumber = tierNumber;
        this.tierName = "tier#" + tierNumber;
        this.totals = new UsageTrackedQueue.ResUsage();
        this.effectiveUsedResources = ResAllocsUtil.emptyOf(this.tierName);
        this.sortedBuckets = new SortedBuckets(this.totals);
        this.allocsShareGetter = allocsShareGetter;
    }

    void setTierSla(TierSla tierSla) {
        this.tierSla = tierSla;
        if (tierSla == null) {
            this.sortedBuckets.getSortedList().forEach(bucket -> bucket.setBucketGuarantees(null));
            this.tierResources = ResAllocsUtil.emptyOf(this.tierName);
        } else {
            this.sortedBuckets.getSortedList().forEach(bucket -> bucket.setBucketGuarantees(tierSla.getBucketAllocs(bucket.getName())));
            tierSla.getAllocsMap().keySet().forEach(this::getOrCreateBucket);
            this.tierResources = tierSla.getTierCapacity();
        }
        this.effectiveUsedResources = ResAllocsUtil.emptyOf(this.tierName);
        this.lastEffectiveUsedResources.clear();
        for (QueueBucket bucket2 : this.sortedBuckets.getSortedList()) {
            this.effectiveUsedResources = ResAllocsUtil.add(this.effectiveUsedResources, bucket2.getEffectiveUsage());
            this.lastEffectiveUsedResources.put(bucket2.getName(), bucket2.getEffectiveUsage());
        }
        this.remainingResources = ResAllocsUtil.subtract(this.tierResources, this.effectiveUsedResources);
        this.sortedBuckets.resort();
    }

    private QueueBucket getOrCreateBucket(QueuableTask t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return this.getOrCreateBucket(t.getQAttributes().getBucketName());
    }

    private QueueBucket getOrCreateBucket(String bucketName) {
        QueueBucket bucket = this.sortedBuckets.get(bucketName);
        if (bucket == null) {
            bucket = new QueueBucket(this.tierNumber, bucketName, this.totals, this.allocsShareGetter);
            this.sortedBuckets.add(bucket);
            bucket.setBucketGuarantees(this.tierSla == null ? null : this.tierSla.getBucketAllocs(bucketName));
        }
        return bucket;
    }

    public int getTierNumber() {
        return this.tierNumber;
    }

    @Override
    public void queueTask(QueuableTask t) throws TaskQueueException {
        this.getOrCreateBucket(t).queueTask(t);
    }

    @Override
    public Assignable<QueuableTask> nextTaskToLaunch() throws TaskQueueException {
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            Assignable<QueuableTask> taskOrFailure = bucket.nextTaskToLaunch();
            if (taskOrFailure == null) continue;
            if (taskOrFailure.hasFailure()) {
                return taskOrFailure;
            }
            QueuableTask task = taskOrFailure.getTask();
            if (bucket.hasGuaranteedCapacityFor(task)) {
                return taskOrFailure;
            }
            if (this.remainingResources == null || ResAllocsUtil.isBounded(task, this.remainingResources)) {
                return taskOrFailure;
            }
            return Assignable.error(task, new AssignmentFailure(VMResource.ResAllocs, 0.0, 0.0, 0.0, "No guaranteed capacity left for queue.\n" + bucket.getBucketCapacityAsString() + "\n" + this.getTierCapacityAsString()));
        }
        return null;
    }

    @Override
    public void assignTask(QueuableTask t) throws TaskQueueException {
        QueueBucket bucket = this.sortedBuckets.remove(t.getQAttributes().getBucketName());
        if (bucket == null) {
            throw new TaskQueueException("Invalid to not find bucket to assign task id=" + t.getId());
        }
        try {
            bucket.assignTask(t);
            this.addUsage(bucket, t);
        }
        finally {
            this.sortedBuckets.add(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean launchTask(QueuableTask t) throws TaskQueueException {
        String bucketName;
        QueueBucket bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding " + t.getId() + ": to ordered buckets: " + this.getSortedListString());
        }
        if ((bucket = this.sortedBuckets.remove(bucketName = t.getQAttributes().getBucketName())) == null) {
            bucket = new QueueBucket(this.tierNumber, bucketName, this.totals, this.allocsShareGetter);
        }
        try {
            if (bucket.launchTask(t)) {
                this.addUsage(bucket, t);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.sortedBuckets.add(bucket);
        }
        return false;
    }

    private void verifySortedBuckets() throws TaskQueueException {
        if (this.sortedBuckets.getSortedList().isEmpty()) {
            return;
        }
        ArrayList<QueueBucket> list = new ArrayList<QueueBucket>(this.sortedBuckets.getSortedList());
        if (list.size() > 1) {
            QueueBucket prev = (QueueBucket)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                if (((QueueBucket)list.get(i)).getDominantUsageShare() < prev.getDominantUsageShare()) {
                    String msg = "Incorrect sorting order : " + this.getSortedListString();
                    throw new TaskQueueException(msg);
                }
                prev = (QueueBucket)list.get(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueuableTask removeTask(String id, QAttributes qAttributes) throws TaskQueueException {
        QueuableTask removed;
        QueueBucket bucket = this.sortedBuckets.remove(qAttributes.getBucketName());
        if (bucket == null) {
            return null;
        }
        try {
            removed = bucket.removeTask(id, qAttributes);
            if (removed != null) {
                this.removeUsage(bucket, removed);
            }
        }
        finally {
            if (bucket.size() > 0 || this.tierSla != null && this.tierSla.getBucketAllocs(bucket.getName()) != null) {
                this.sortedBuckets.add(bucket);
            }
        }
        return removed;
    }

    private void addUsage(QueueBucket bucket, QueuableTask t) {
        this.totals.addUsage(t);
        this.updateEffectiveBucketTotals(bucket);
    }

    private void removeUsage(QueueBucket bucket, QueuableTask removed) {
        this.totals.remUsage(removed);
        this.updateEffectiveBucketTotals(bucket);
    }

    private void updateEffectiveBucketTotals(QueueBucket bucket) {
        ResAllocs lastEffective = this.lastEffectiveUsedResources.get(bucket.getName());
        if (lastEffective != null) {
            this.effectiveUsedResources = ResAllocsUtil.subtract(this.effectiveUsedResources, lastEffective);
        }
        this.lastEffectiveUsedResources.put(bucket.getName(), bucket.getEffectiveUsage());
        this.effectiveUsedResources = ResAllocsUtil.add(this.effectiveUsedResources, bucket.getEffectiveUsage());
        this.remainingResources = this.tierResources == null ? null : ResAllocsUtil.subtract(this.tierResources, this.effectiveUsedResources);
    }

    @Override
    public double getDominantUsageShare() {
        return 0.0;
    }

    @Override
    public void setTaskReadyTime(String taskId, QAttributes qAttributes, long when) throws TaskQueueException {
        QueueBucket bucket = this.sortedBuckets.get(qAttributes.getBucketName());
        if (bucket != null) {
            bucket.setTaskReadyTime(taskId, qAttributes, when);
        }
    }

    @Override
    public void reset() {
        if (logger.isDebugEnabled()) {
            try {
                this.verifySortedBuckets();
            }
            catch (TaskQueueException e) {
                logger.error(e.getMessage());
            }
        }
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            bucket.reset();
        }
    }

    private String getSortedListString() {
        StringBuilder b = new StringBuilder("Tier " + this.tierNumber + " sortedBs: [");
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            b.append(bucket.getName()).append(" (").append(bucket.getDominantUsageShare()).append("), ");
        }
        b.append("]");
        return b.toString();
    }

    private String getTierCapacityAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.tierResources != null) {
            sb.append("Tier ").append(this.tierNumber).append(" Total Capacity: ").append(this.tierResources.getAsString());
        }
        if (this.effectiveUsedResources != null) {
            sb.append("\nTier ").append(this.tierNumber).append(" Used Capacity: ").append(this.effectiveUsedResources.getAsString());
        }
        if (this.remainingResources != null) {
            sb.append("\nTier ").append(this.tierNumber).append(" Remaining Capacity: ").append(this.remainingResources.getAsString());
        }
        return sb.toString();
    }

    @Override
    public void setTotalResources(Map<VMResource, Double> totalResourcesMap) {
        if (this.totalResMapChanged(this.currTotalResourcesMap, totalResourcesMap)) {
            this.currTotalResourcesMap.clear();
            this.currTotalResourcesMap.putAll(totalResourcesMap);
            for (QueueBucket b : this.sortedBuckets.getSortedList()) {
                b.setTotalResources(this.tierResources);
            }
            logger.info("Re-sorting buckets in tier " + this.tierNumber + " after totals changed");
            this.sortedBuckets.resort();
        }
    }

    private boolean totalResMapChanged(Map<VMResource, Double> currTotalResourcesMap, Map<VMResource, Double> totalResourcesMap) {
        if (currTotalResourcesMap.size() != totalResourcesMap.size()) {
            return true;
        }
        HashSet<VMResource> curr = new HashSet<VMResource>(currTotalResourcesMap.keySet());
        for (VMResource r : totalResourcesMap.keySet()) {
            Double c = currTotalResourcesMap.get((Object)r);
            Double n = totalResourcesMap.get((Object)r);
            if (c == null && n != null || c != null && n == null || n != null && !n.equals(c)) {
                return true;
            }
            curr.remove((Object)r);
        }
        return !curr.isEmpty();
    }

    @Override
    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException {
        HashMap<TaskQueue.TaskState, Collection<QueuableTask>> result = new HashMap<TaskQueue.TaskState, Collection<QueuableTask>>();
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            Map<TaskQueue.TaskState, Collection<QueuableTask>> allTasks = bucket.getAllTasks();
            if (allTasks.isEmpty()) continue;
            for (TaskQueue.TaskState s : TaskQueue.TaskState.values()) {
                Collection<QueuableTask> q = allTasks.get((Object)s);
                if (q == null || q.isEmpty()) continue;
                LinkedList<QueuableTask> resQ = (LinkedList<QueuableTask>)result.get((Object)s);
                if (resQ == null) {
                    resQ = new LinkedList<QueuableTask>();
                    result.put(s, resQ);
                }
                resQ.addAll(q);
            }
        }
        return result;
    }
}

