/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.spring.core.scanner;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.annotation.ElasticJobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathJobScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathJobScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ElasticJobConfiguration.class));
        Set beanDefinitions = super.doScan(basePackages);
        if (!beanDefinitions.isEmpty()) {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        BeanDefinitionRegistry registry = this.getRegistry();
        for (BeanDefinitionHolder holder : beanDefinitions) {
            Class<?> jobClass;
            ScannedGenericBeanDefinition definition = (ScannedGenericBeanDefinition)holder.getBeanDefinition();
            try {
                jobClass = Class.forName(definition.getMetadata().getClassName());
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            ElasticJobConfiguration jobAnnotation = jobClass.getAnnotation(ElasticJobConfiguration.class);
            String registryCenter = jobAnnotation.registryCenter();
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ScheduleJobBootstrap.class);
            factory.setInitMethodName("schedule");
            if (!StringUtils.isEmpty((CharSequence)registryCenter)) {
                factory.addConstructorArgReference(registryCenter);
            } else {
                factory.addConstructorArgValue((Object)new RuntimeBeanReference(CoordinatorRegistryCenter.class));
            }
            factory.addConstructorArgReference(Objects.requireNonNull(holder.getBeanName()));
            registry.registerBeanDefinition(jobAnnotation.jobName(), (BeanDefinition)factory.getBeanDefinition());
        }
    }
}

