/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class MonitorExecutionListenerManager
extends AbstractListenerManager {
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;

    public MonitorExecutionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new MonitorExecutionSettingsChangedJobListener());
    }

    class MonitorExecutionSettingsChangedJobListener
    implements DataChangedEventListener {
        MonitorExecutionSettingsChangedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (MonitorExecutionListenerManager.this.configNode.isConfigPath(event.getKey()) && DataChangedEvent.Type.UPDATED == event.getType() && !((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class)).toJobConfiguration().isMonitorExecution()) {
                MonitorExecutionListenerManager.this.executionService.clearAllRunningInfo();
            }
        }
    }
}

