/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.listener.AbstractDataChangedListener;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DataChangedEventDispatcher
implements ApplicationListener<DataChangedEvent>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangedEventDispatcher.class);
    private final ApplicationContext applicationContext;
    private List<DataChangedListener> listeners;
    @Resource
    private ClusterProperties clusterProperties;
    @Resource
    @Nullable
    private ClusterSelectMasterService shenyuClusterSelectMasterService;

    public DataChangedEventDispatcher(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(@NotNull DataChangedEvent event) {
        block10: for (DataChangedListener listener : this.listeners) {
            if (!(listener instanceof AbstractDataChangedListener) && this.clusterProperties.isEnabled() && Objects.nonNull(this.shenyuClusterSelectMasterService) && !this.shenyuClusterSelectMasterService.isMaster()) {
                LOG.info("received DataChangedEvent, not master, pass");
                return;
            }
            int size = event.getSource() instanceof Collection ? event.getSource().size() : 1;
            LOG.info("received DataChangedEvent, group={}, size={}, type={}", new Object[]{event.getGroupKey(), size, event.getEventType()});
            if (LOG.isDebugEnabled()) {
                LOG.debug("received DataChangedEvent payload: {}", (Object)JsonUtils.toJson((Object)((Object)event)));
            }
            switch (event.getGroupKey()) {
                case APP_AUTH: {
                    listener.onAppAuthChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case PLUGIN: {
                    listener.onPluginChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case RULE: {
                    listener.onRuleChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case SELECTOR: {
                    listener.onSelectorChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case META_DATA: {
                    listener.onMetaDataChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case PROXY_SELECTOR: {
                    listener.onProxySelectorChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case AI_PROXY_API_KEY: {
                    listener.onAiProxyApiKeyChanged((List)event.getSource(), event.getEventType());
                    continue block10;
                }
                case DISCOVER_UPSTREAM: {
                    listener.onDiscoveryUpstreamChanged((List)event.getSource(), event.getEventType());
                    ((LoadServiceDocEntry)this.applicationContext.getBean(LoadServiceDocEntry.class)).loadDocOnUpstreamChanged((List<DiscoverySyncData>)event.getSource(), event.getEventType());
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected value: " + event.getGroupKey());
        }
    }

    public void afterPropertiesSet() {
        Collection listenerBeans = this.applicationContext.getBeansOfType(DataChangedListener.class).values();
        this.listeners = Collections.unmodifiableList(new ArrayList(listenerBeans));
    }
}

