/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class DictDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final ShenyuDictService shenyuDictService;

    public DictDataConfigsExportImportHandler(ShenyuDictService shenyuDictService) {
        this.shenyuDictService = shenyuDictService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Dict;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<ShenyuDictVO> dictDataList = this.shenyuDictService.listAllData();
        if (CollectionUtils.isNotEmpty(dictDataList)) {
            return Optional.of(JsonUtils.toJson(dictDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List dictList = GsonUtils.getInstance().fromList(data, ShenyuDictDTO.class);
        ConfigImportResult configImportResult = this.shenyuDictService.importData(dictList);
        context.getResult().put("dictImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("dictImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

