/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import org.apache.shenyu.admin.mapper.ScalePolicyMapper;
import org.apache.shenyu.admin.model.dto.ScalePolicyDTO;
import org.apache.shenyu.admin.model.entity.ScalePolicyDO;
import org.apache.shenyu.admin.model.vo.ScalePolicyVO;
import org.apache.shenyu.admin.scale.scaler.ScaleService;
import org.apache.shenyu.admin.scale.scaler.cache.ScalePolicyCache;
import org.apache.shenyu.admin.service.ScalePolicyService;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.stereotype.Service;

@Service
public class ScalePolicyServiceImpl
implements ScalePolicyService {
    private final ScalePolicyMapper scalePolicyMapper;
    private final ScalePolicyCache scalePolicyCache;
    private final ScaleService scaleService;

    public ScalePolicyServiceImpl(ScalePolicyMapper scalePolicyMapper, ScalePolicyCache scalePolicyCache, ScaleService scaleService) {
        this.scalePolicyMapper = scalePolicyMapper;
        this.scalePolicyCache = scalePolicyCache;
        this.scaleService = scaleService;
    }

    @Override
    public List<ScalePolicyVO> selectAll() {
        return ListUtil.map(this.scalePolicyMapper.selectAll(), ScalePolicyVO::buildScalePolicyVO);
    }

    @Override
    public ScalePolicyVO findById(String id) {
        return ScalePolicyVO.buildScalePolicyVO(this.scalePolicyMapper.selectByPrimaryKey(id));
    }

    @Override
    public int update(ScalePolicyDTO scalePolicyDTO) {
        ScalePolicyDO scalePolicy = ScalePolicyDO.buildScalePolicyDO(scalePolicyDTO);
        int rows = this.scalePolicyMapper.updateByPrimaryKeySelective(scalePolicy);
        if (rows > 0) {
            this.scalePolicyCache.updatePolicy(scalePolicy);
            this.scaleService.executeScaling();
        }
        return rows;
    }
}

