/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.McpToolsRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterMcpServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientRegisterMcpServiceImpl.class);

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return null;
    }

    @Override
    protected String ruleHandler() {
        return null;
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        if (LOG.isDebugEnabled()) {
            LOG.debug("mcp register metadata:{}", (Object)GsonUtils.getInstance().toJson((Object)metaDataDTO));
        }
        MetaDataDO exist = metaDataService.findByPathAndNamespaceId(metaDataDTO.getPath(), metaDataDTO.getNamespaceId());
        metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        return null;
    }

    @Override
    public String rpcType() {
        return RpcTypeEnum.MCP.getName();
    }

    public void registerMcpTools(McpToolsRegisterDTO mcpToolsRegisterDTO) {
        MetaDataRegisterDTO metaDataRegisterDTO = mcpToolsRegisterDTO.getMetaDataRegisterDTO();
        String namespaceId = (String)StringUtils.defaultIfEmpty((CharSequence)mcpToolsRegisterDTO.getNamespaceId(), (CharSequence)"649330b6-c2d7-4edc-be8e-8a54df9eb385");
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        this.checkNamespacePluginRel(namespaceId, pluginName);
        mcpToolsRegisterDTO.setNamespaceId(namespaceId);
        String selectorHandler = "";
        String selectorId = this.getSelectorService().registerDefault(metaDataRegisterDTO, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()), selectorHandler);
        String ruleHandler = mcpToolsRegisterDTO.getMcpConfig();
        RuleDTO ruleDTO = this.buildMcpRuleDTO(selectorId, metaDataRegisterDTO, ruleHandler);
        this.getRuleService().registerDefault(ruleDTO);
        this.registerMetadata(metaDataRegisterDTO);
        String contextPath = metaDataRegisterDTO.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPath(metaDataRegisterDTO);
        }
    }

    private RuleDTO buildMcpRuleDTO(String selectorId, MetaDataRegisterDTO metaDataRegisterDTO, String ruleHandler) {
        RuleDTO ruleDTO = RuleDTO.builder().selectorId(selectorId).matchMode(MatchModeEnum.AND.getCode()).name(metaDataRegisterDTO.getRuleName()).enabled(Boolean.TRUE).loged(Boolean.TRUE).matchRestful(Boolean.FALSE).sort(1).handle(ruleHandler).namespaceId(metaDataRegisterDTO.getNamespaceId()).build();
        RuleConditionDTO ruleConditionDTO = RuleConditionDTO.builder().paramType(ParamTypeEnum.URI.getName()).paramName("/").paramValue("/**").build();
        ruleConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        ruleDTO.setRuleConditions(Collections.singletonList(ruleConditionDTO));
        return ruleDTO;
    }
}

