/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.utils.UrlPathUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class OpenApiUtils {
    private static final String EVERY_PATH = "**";
    private static final String LEFT_ANGLE_BRACKETS = "{";
    private static final String RIGHT_ANGLE_BRACKETS = "}";
    private static final String[] QUERY_CLASSES = new String[]{"org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestPart"};

    public static List<Parameter> generateDocumentParameters(String path, Method method) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Pair<Boolean, Annotation[][]> query = OpenApiUtils.isQuery(method);
        if (((Boolean)query.getLeft()).booleanValue()) {
            for (Annotation[] annotations : (Annotation[][])query.getRight()) {
                if (annotations.length <= 0 || !OpenApiUtils.isQueryName(annotations[0].annotationType().getName(), QUERY_CLASSES)) continue;
                for (Annotation annotation : annotations) {
                    String name = "";
                    boolean required = false;
                    if (StringUtils.equals((CharSequence)QUERY_CLASSES[0], (CharSequence)annotation.annotationType().getName())) {
                        RequestParam requestParam = (RequestParam)annotation;
                        name = requestParam.value();
                        required = requestParam.required();
                    }
                    if (StringUtils.equals((CharSequence)QUERY_CLASSES[1], (CharSequence)annotation.annotationType().getName())) {
                        RequestPart requestPart = (RequestPart)annotation;
                        name = requestPart.value();
                        required = requestPart.required();
                    }
                    Parameter parameter = new Parameter();
                    parameter.setIn("query");
                    parameter.setRequired(required);
                    parameter.setName(name);
                    parameter.setSchema(new Schema("string", null));
                    list.add(parameter);
                }
            }
        } else {
            List<String> segments = UrlPathUtils.getSegments(path);
            for (String segment : segments) {
                if (EVERY_PATH.equals(segment)) {
                    Parameter parameter = new Parameter();
                    parameter.setIn("path");
                    parameter.setName(segment);
                    parameter.setRequired(true);
                    parameter.setSchema(new Schema("string", null));
                    list.add(parameter);
                }
                if (!segment.startsWith(LEFT_ANGLE_BRACKETS) || !segment.endsWith(RIGHT_ANGLE_BRACKETS)) continue;
                String name = segment.substring(1, segment.length() - 1);
                Parameter parameter = new Parameter();
                parameter.setIn("path");
                parameter.setName(name);
                parameter.setRequired(true);
                parameter.setSchema(new Schema("string", null));
                list.add(parameter);
            }
        }
        return list;
    }

    private static Pair<Boolean, Annotation[][]> isQuery(Method method) {
        int n = 0;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Annotation[][] annotationArray = parameterAnnotations;
        int n2 = annotationArray.length;
        if (n < n2) {
            Annotation[] parameterAnnotation = annotationArray[n];
            if (parameterAnnotation.length > 0 && OpenApiUtils.isQueryName(parameterAnnotation[0].annotationType().getName(), QUERY_CLASSES)) {
                return Pair.of((Object)true, (Object)parameterAnnotations);
            }
            return Pair.of((Object)false, null);
        }
        return Pair.of((Object)false, null);
    }

    private static boolean isQueryName(String name, String[] names) {
        for (String s : names) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> generateDocumentResponse(String path) {
        ImmutableMap contentMap = ImmutableMap.builder().put((Object)"*/*", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"type", (Object)"string"))).build();
        ImmutableMap successMap = ImmutableMap.builder().put((Object)"description", (Object)path).put((Object)"content", (Object)contentMap).build();
        ImmutableMap notFoundMap = ImmutableMap.builder().put((Object)"description", (Object)StringUtils.join((Object[])new String[]{"the path [", path, "] not found"})).put((Object)"content", (Object)contentMap).build();
        ImmutableMap conflictMap = ImmutableMap.builder().put((Object)"description", (Object)"conflict").put((Object)"content", (Object)contentMap).build();
        return ImmutableMap.builder().put((Object)"200", (Object)successMap).put((Object)"404", (Object)notFoundMap).put((Object)"409", (Object)conflictMap).build();
    }

    public static ResponseType parseReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        return OpenApiUtils.parseType("ROOT", returnType, 0, new HashMap(16));
    }

    private static ResponseType parseType(String name, Type type, int depth, Map<TypeVariable<?>, Type> typeVariableMap) {
        ResponseType responseType = new ResponseType();
        if (StringUtils.isBlank((CharSequence)name)) {
            responseType.setName(type.getTypeName());
        } else {
            responseType.setName(name);
        }
        if (depth > 5) {
            responseType.setType("object");
            return responseType;
        }
        if (type instanceof Class) {
            return OpenApiUtils.parseClass(responseType, (Class)type, depth, typeVariableMap);
        }
        if (type instanceof ParameterizedType) {
            return OpenApiUtils.parseParameterizedType(responseType, (ParameterizedType)type, depth, typeVariableMap);
        }
        if (type instanceof GenericArrayType) {
            return OpenApiUtils.parseGenericArrayType(responseType, (GenericArrayType)type, depth, typeVariableMap);
        }
        if (type instanceof TypeVariable) {
            Type actualType = typeVariableMap.get(type);
            if (Objects.nonNull(actualType)) {
                return OpenApiUtils.parseType(name, actualType, depth, typeVariableMap);
            }
            if (((TypeVariable)type).getBounds().length > 0) {
                Type upperBound = ((TypeVariable)type).getBounds()[0];
                return OpenApiUtils.parseType(name, upperBound, depth, typeVariableMap);
            }
            responseType.setType("object");
            return responseType;
        }
        if (type instanceof WildcardType) {
            responseType.setType("object");
            return responseType;
        }
        responseType.setType("object");
        return responseType;
    }

    private static ResponseType parseClass(ResponseType responseType, Class<?> clazz, int depth, Map<TypeVariable<?>, Type> typeVariableMap) {
        if (clazz.isArray()) {
            responseType.setType("array");
            responseType.setRefs(Collections.singletonList(OpenApiUtils.parseType("ITEMS", clazz.getComponentType(), depth + 1, typeVariableMap)));
            return responseType;
        }
        if (clazz.isEnum()) {
            responseType.setType("string");
            return responseType;
        }
        if (OpenApiUtils.isBooleanType(clazz)) {
            responseType.setType("boolean");
            return responseType;
        }
        if (OpenApiUtils.isIntegerType(clazz)) {
            responseType.setType("integer");
            return responseType;
        }
        if (OpenApiUtils.isNumberType(clazz)) {
            responseType.setType("number");
            return responseType;
        }
        if (OpenApiUtils.isStringType(clazz)) {
            responseType.setType("string");
            return responseType;
        }
        if (OpenApiUtils.isDateType(clazz)) {
            responseType.setType("date");
            return responseType;
        }
        ArrayList<ResponseType> refs = new ArrayList<ResponseType>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            refs.add(OpenApiUtils.parseType(field.getName(), field.getGenericType(), depth + 1, typeVariableMap));
        }
        responseType.setType("object");
        responseType.setRefs(refs);
        return responseType;
    }

    private static ResponseType parseParameterizedType(ResponseType responseType, ParameterizedType type, int depth, Map<TypeVariable<?>, Type> typeVariableMap) {
        Class rawType = (Class)type.getRawType();
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = rawType.getTypeParameters();
        HashMap newTypeVariableMap = new HashMap(typeVariableMap);
        for (int i = 0; i < typeVariables.length; ++i) {
            newTypeVariableMap.put(typeVariables[i], actualTypeArguments[i]);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            Type actualType = actualTypeArguments[0];
            ResponseType elementParam = OpenApiUtils.parseType("ITEMS", actualType, depth + 1, newTypeVariableMap);
            responseType.setRefs(Collections.singletonList(elementParam));
            responseType.setType("array");
            return responseType;
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type keyType = actualTypeArguments[0];
            Type valueType = actualTypeArguments[1];
            ResponseType keyParam = OpenApiUtils.parseType("key", keyType, depth + 1, newTypeVariableMap);
            ResponseType valueParam = OpenApiUtils.parseType("value", valueType, depth + 1, newTypeVariableMap);
            ArrayList<ResponseType> children = new ArrayList<ResponseType>();
            children.add(keyParam);
            children.add(valueParam);
            responseType.setRefs(children);
            responseType.setType("map");
            return responseType;
        }
        ArrayList<ResponseType> refs = new ArrayList<ResponseType>();
        for (Field field : rawType.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ResponseType fieldParam = OpenApiUtils.parseType(field.getName(), field.getGenericType(), depth + 1, newTypeVariableMap);
            refs.add(fieldParam);
        }
        responseType.setType("object");
        responseType.setRefs(refs);
        return responseType;
    }

    private static ResponseType parseGenericArrayType(ResponseType responseType, GenericArrayType type, int depth, Map<TypeVariable<?>, Type> typeVariableMap) {
        responseType.setRefs(Collections.singletonList(OpenApiUtils.parseType("ITEMS", type.getGenericComponentType(), depth + 1, typeVariableMap)));
        responseType.setType("array");
        return responseType;
    }

    private static boolean isDateType(Class<?> clazz) {
        return clazz == Date.class || clazz == LocalDate.class || clazz == LocalDateTime.class || clazz == LocalTime.class;
    }

    private static boolean isStringType(Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz) || clazz == Character.TYPE || clazz == Character.class;
    }

    private static boolean isBooleanType(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    private static boolean isIntegerType(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class;
    }

    private static boolean isNumberType(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class;
    }

    public static class Parameter {
        private String name;
        private String in;
        private String description;
        private boolean required;
        private Schema schema;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIn() {
            return this.in;
        }

        public void setIn(String in) {
            this.in = in;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }
    }

    public static class Schema {
        private String type;
        private String format;

        public Schema(String type, String format) {
            this.type = type;
            this.format = format;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class ResponseType {
        private String name;
        private String description;
        private String type;
        private List<ResponseType> refs;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<ResponseType> getRefs() {
            return this.refs;
        }

        public void setRefs(List<ResponseType> refs) {
            this.refs = refs;
        }
    }
}

