/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.ResolvableType;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.ServiceActivatorFactoryBean;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class ServiceActivatorAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<ServiceActivator> {
    public ServiceActivatorAnnotationPostProcessor() {
        this.messageHandlerAttributes.addAll(Arrays.asList("outputChannel", "requiresReply"));
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        BeanDefinition handlerBeanDefinition = super.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        if (handlerBeanDefinition != null) {
            return handlerBeanDefinition;
        }
        BeanDefinition targetObjectBeanDefinition = ServiceActivatorAnnotationPostProcessor.buildLambdaMessageProcessor(handlerBeanType, beanDefinition);
        if (targetObjectBeanDefinition == null) {
            targetObjectBeanDefinition = new RuntimeBeanReference(beanName);
        }
        AbstractBeanDefinition serviceActivatorBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(ServiceActivatorFactoryBean.class).addPropertyValue("targetObject", (Object)targetObjectBeanDefinition).getBeanDefinition();
        new AbstractMethodAnnotationPostProcessor.BeanDefinitionPropertiesMapper((BeanDefinition)serviceActivatorBeanDefinition, annotations).setPropertyValue("requiresReply").setPropertyValue("async");
        return serviceActivatorBeanDefinition;
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String isAsync;
        ServiceActivatingHandler serviceActivator = new ServiceActivatingHandler(bean, method);
        String requiresReply = MessagingAnnotationUtils.resolveAttribute(annotations, "requiresReply", String.class);
        if (StringUtils.hasText((String)requiresReply)) {
            serviceActivator.setRequiresReply(this.resolveAttributeToBoolean(requiresReply));
        }
        if (StringUtils.hasText((String)(isAsync = MessagingAnnotationUtils.resolveAttribute(annotations, "async", String.class)))) {
            serviceActivator.setAsync(this.resolveAttributeToBoolean(isAsync));
        }
        ServiceActivatorAnnotationPostProcessor.setOutputChannelIfPresent(annotations, serviceActivator);
        return serviceActivator;
    }
}

