/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FilterInvoker
implements Invoker {
    protected Filter nextFilter;
    protected FilterInvoker invoker;
    protected AbstractInterfaceConfig config;
    protected Map<String, Object> configContext;

    protected FilterInvoker(AbstractInterfaceConfig config) {
        this.config = config;
        if (config != null) {
            this.configContext = config.getConfigValueCache(false);
        }
    }

    public FilterInvoker(Filter nextFilter, FilterInvoker invoker, AbstractInterfaceConfig config) {
        this.nextFilter = nextFilter;
        this.invoker = invoker;
        this.config = config;
        if (config != null) {
            this.configContext = config.getConfigValueCache(false);
        }
    }

    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        if (this.nextFilter == null && this.invoker == null) {
            throw new SofaRpcException(170, LogCodes.getLog("020120002"));
        }
        return this.nextFilter == null ? this.invoker.invoke(request) : this.nextFilter.invoke(this.invoker, request);
    }

    protected Map<String, Object> getConfigContext() {
        return this.configContext;
    }

    public AbstractInterfaceConfig getConfig() {
        return this.config;
    }

    protected FilterInvoker getInvoker() {
        return this.invoker;
    }

    protected boolean getBooleanMethodParam(String methodName, String paramKey, boolean defaultValue) {
        if (CommonUtils.isEmpty(this.configContext)) {
            return defaultValue;
        }
        Boolean o = (Boolean)this.configContext.get(this.buildMethodKey(methodName, paramKey));
        if (o == null) {
            o = (Boolean)this.configContext.get(paramKey);
            return o == null ? defaultValue : o;
        }
        return o;
    }

    protected String getStringMethodParam(String methodName, String paramKey, String defaultValue) {
        if (CommonUtils.isEmpty(this.configContext)) {
            return defaultValue;
        }
        String o = (String)this.configContext.get(this.buildMethodKey(methodName, paramKey));
        if (o == null) {
            o = (String)this.configContext.get(paramKey);
            return o == null ? defaultValue : o;
        }
        return o;
    }

    protected int getIntMethodParam(String methodName, String paramKey, int defaultValue) {
        if (CommonUtils.isEmpty(this.configContext)) {
            return defaultValue;
        }
        Integer o = (Integer)this.configContext.get(this.buildMethodKey(methodName, paramKey));
        if (o == null) {
            o = (Integer)this.configContext.get(paramKey);
            return o == null ? defaultValue : o;
        }
        return o;
    }

    protected Object getMethodParam(String methodName, String paramKey) {
        if (CommonUtils.isEmpty(this.configContext)) {
            return null;
        }
        Object o = this.configContext.get(this.buildMethodKey(methodName, paramKey));
        return o == null ? this.configContext.get(paramKey) : o;
    }

    private String buildMethodKey(String methodName, String key) {
        return '.' + methodName + '.' + key;
    }
}

