/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.triple.stream;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.transport.SofaStreamObserver;
import com.alipay.sofa.rpc.utils.TripleExceptionUtils;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import triple.Response;

public class ResponseSerializeSofaStreamObserver<T>
implements SofaStreamObserver<T> {
    private final StreamObserver<Response> streamObserver;
    private Serializer serializer;
    private String serializeType;

    public ResponseSerializeSofaStreamObserver(StreamObserver<Response> streamObserver, String serializeType) {
        this.streamObserver = streamObserver;
        if (StringUtils.isNotBlank(serializeType)) {
            this.serializer = SerializerFactory.getSerializer(serializeType);
            this.serializeType = serializeType;
        }
    }

    @Override
    public void onNext(T message) {
        Response.Builder builder = Response.newBuilder();
        builder.setType(message.getClass().getName());
        builder.setSerializeType(this.serializeType);
        builder.setData(ByteString.copyFrom((byte[])this.serializer.encode(message, null).array()));
        this.streamObserver.onNext((Object)builder.build());
    }

    @Override
    public void onCompleted() {
        this.streamObserver.onCompleted();
    }

    @Override
    public void onError(Throwable throwable) {
        this.streamObserver.onError((Throwable)TripleExceptionUtils.asStatusRuntimeException(throwable));
    }

    public void setSerializeType(String serializeType) {
        this.serializer = SerializerFactory.getSerializer(serializeType);
        this.serializeType = serializeType;
    }
}

