/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.plugin;

import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cryptor.handler.AbstractCryptorPluginDataHandler;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.MapTypeEnum;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractCryptorPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCryptorPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CryptorRuleHandler ruleHandle = (CryptorRuleHandler)AbstractCryptorPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(ruleHandle)) {
            LOG.error("{} rule configuration is null :{}", (Object)this.named(), (Object)rule.getId());
            return chain.execute(exchange);
        }
        Pair<Boolean, String> pair = CryptorUtil.checkParam(ruleHandle);
        if (Boolean.TRUE.equals(pair.getLeft())) {
            ShenyuResultEnum resultEnum = this.checkErrorEnum();
            return WebFluxResultUtils.failedResult((int)resultEnum.getCode(), (String)(resultEnum.getMsg() + "[" + (String)pair.getRight() + "]"), (ServerWebExchange)exchange);
        }
        return this.doExecute0(exchange, chain, selector, rule, ruleHandle);
    }

    protected abstract Mono<Void> doExecute0(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4, CryptorRuleHandler var5);

    protected abstract ShenyuResultEnum checkErrorEnum();

    protected abstract String fieldErrorParse(String var1, ServerWebExchange var2);

    protected String convert(String originalBody, CryptorRuleHandler ruleHandle, ServerWebExchange exchange) {
        String converted = MapTypeEnum.mapType(ruleHandle.getMapType()).convert(originalBody, ruleHandle, exchange);
        if (Objects.isNull(converted)) {
            return this.fieldErrorParse(originalBody, exchange);
        }
        return converted;
    }
}

