/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.request.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.plugin.AiRequestTransformerConfig;
import org.apache.shenyu.common.dto.convert.rule.AiRequestTransformerHandle;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.registry.AiModelFactoryRegistry;
import org.apache.shenyu.plugin.ai.transformer.request.cache.ChatClientCache;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class AiRequestTransformerPluginHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, AiRequestTransformerHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    private final AiModelFactoryRegistry aiModelFactoryRegistry;

    public AiRequestTransformerPluginHandler(AiModelFactoryRegistry aiModelFactoryRegistry) {
        this.aiModelFactoryRegistry = aiModelFactoryRegistry;
    }

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            AiRequestTransformerConfig aiRequestTransformerConfig = (AiRequestTransformerConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), AiRequestTransformerConfig.class);
            if (Objects.isNull(aiRequestTransformerConfig)) {
                return;
            }
            AiModelFactory factory = this.aiModelFactoryRegistry.getFactory(AiModelProviderEnum.getByName((String)aiRequestTransformerConfig.getProvider()));
            ChatClientCache.getInstance().init("default", factory.createAiModel(AiRequestTransformerPluginHandler.convertConfig(aiRequestTransformerConfig)));
            Singleton.INST.single(AiRequestTransformerConfig.class, (Object)aiRequestTransformerConfig);
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            AiRequestTransformerHandle aiRequestTransformerHandle = (AiRequestTransformerHandle)GsonUtils.getInstance().fromJson(s, AiRequestTransformerHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)aiRequestTransformerHandle);
        });
        ChatClientCache.getInstance().destroyClient(ruleData.getId());
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
        AiRequestTransformerHandle aiRequestTransformerHandle = (AiRequestTransformerHandle)GsonUtils.getInstance().fromJson(ruleData.getHandle(), AiRequestTransformerHandle.class);
        ChatClientCache.getInstance().destroyClient(ruleData.getId() + aiRequestTransformerHandle.getProvider());
    }

    public String pluginNamed() {
        return PluginEnum.AI_REQUEST_TRANSFORMER.getName();
    }

    public static AiCommonConfig convertConfig(AiRequestTransformerConfig aiRequestTransformerConfig) {
        AiCommonConfig aiCommonConfig = new AiCommonConfig();
        Optional.ofNullable(aiRequestTransformerConfig.getBaseUrl()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setBaseUrl(arg_0));
        Optional.ofNullable(aiRequestTransformerConfig.getProvider()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setProvider(arg_0));
        Optional.ofNullable(aiRequestTransformerConfig.getModel()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setModel(arg_0));
        Optional.ofNullable(aiRequestTransformerConfig.getApiKey()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setApiKey(arg_0));
        return aiCommonConfig;
    }
}

