/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;

public class TypeBool
implements BreezeType<Boolean> {
    TypeBool() {
    }

    public static boolean readBool(BreezeBuffer buffer) throws BreezeException {
        byte b = buffer.get();
        if (b == -102) {
            return true;
        }
        if (b == -101) {
            return false;
        }
        throw new BreezeException("boolean type not correct. expect type:-102 or -101, real type:" + b);
    }

    @Override
    public byte getType() {
        return -102;
    }

    @Override
    public Boolean read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        return TypeBool.readBool(buffer);
    }

    @Override
    public void write(BreezeBuffer buffer, Boolean value, boolean withType) throws BreezeException {
        if (value.booleanValue()) {
            buffer.put((byte)-102);
        } else {
            buffer.put((byte)-101);
        }
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Boolean field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null && field.booleanValue()) {
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

