/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.auth.sign;

import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.huaweicloud.lts.producer.auth.sign.Sign;
import com.huaweicloud.lts.producer.auth.sign.SignCacheKey;
import com.huaweicloud.lts.producer.exception.ClientException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignCache {
    private static final Logger LOG = LoggerFactory.getLogger(SignCache.class);
    private static final SignCache signCache = new SignCache();
    private static LoadingCache<SignCacheKey, String> cache;

    private SignCache() {
        cache = CacheBuilder.newBuilder().initialCapacity(1024).expireAfterAccess(Duration.ofDays(1L)).removalListener(notification -> LOG.debug("[{}] remove key [{}] [{}]", new Object[]{notification.getCause(), JSONObject.toJSONString((Object)notification.getKey()), JSONObject.toJSONString((Object)notification.getValue())})).build((CacheLoader)new CacheLoader<SignCacheKey, String>(){

            public String load(SignCacheKey signCacheKeyInfo) throws ClientException {
                return Sign.buildDerivationKey(signCacheKeyInfo.getAccessKey(), signCacheKeyInfo.getSecretKey(), signCacheKeyInfo.getCredentialScope());
            }
        });
    }

    public static SignCache getInstance() {
        return signCache;
    }

    public String getValue(SignCacheKey signCacheKey) {
        try {
            return (String)cache.get((Object)signCacheKey);
        }
        catch (ExecutionException e) {
            LOG.error("Sign get {} value error {} ", (Object)JSONObject.toJSONString((Object)signCacheKey), (Object)e);
            return null;
        }
    }
}

