/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.util;

import com.huaweicloud.lts.producer.model.log.LogContent;
import com.huaweicloud.lts.producer.model.log.LogItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class LogSizeCalculator {
    public static int calculate(LogItem logItem) {
        int sizeInBytes = 4;
        for (LogContent logContent : logItem.getContents()) {
            sizeInBytes += logContent.getLog().length();
        }
        if (StringUtils.isNotEmpty((CharSequence)logItem.getLabels())) {
            sizeInBytes += logItem.getLabels().length();
        }
        return sizeInBytes;
    }

    public static int calculate(List<LogItem> logItems) {
        int sizeInBytes = 0;
        for (LogItem logItem : logItems) {
            sizeInBytes += LogSizeCalculator.calculate(logItem);
        }
        return sizeInBytes;
    }
}

