/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SchemaKeyword {
    TAG_SCHEMA("$schema", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_SCHEMA_VALUE(SchemaVersion::getIdentifier, Collections.emptyList(), Collections.emptyList()),
    TAG_ID("$id", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_ANCHOR("$anchor", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_DEFINITIONS(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "definitions" : "$defs", Collections.singletonList(TagContent.NAMED_SCHEMAS), Collections.emptyList()),
    TAG_REF("$ref", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_REF_MAIN("#"),
    TAG_REF_PREFIX(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "#/definitions/" : "#/$defs/", Collections.emptyList(), Collections.emptyList()),
    TAG_TYPE("type", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_TYPE_NULL(SchemaType.NULL.getSchemaKeywordValue()),
    TAG_TYPE_ARRAY(SchemaType.ARRAY.getSchemaKeywordValue()),
    TAG_TYPE_OBJECT(SchemaType.OBJECT.getSchemaKeywordValue()),
    TAG_TYPE_BOOLEAN(SchemaType.BOOLEAN.getSchemaKeywordValue()),
    TAG_TYPE_STRING(SchemaType.STRING.getSchemaKeywordValue()),
    TAG_TYPE_INTEGER(SchemaType.INTEGER.getSchemaKeywordValue()),
    TAG_TYPE_NUMBER(SchemaType.NUMBER.getSchemaKeywordValue()),
    TAG_PROPERTIES("properties", Collections.singletonList(TagContent.NAMED_SCHEMAS), Collections.singletonList(SchemaType.OBJECT)),
    TAG_UNEVALUATED_PROPERTIES("unevaluatedProperties", Collections.singletonList(TagContent.SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_ITEMS("items", Arrays.asList(TagContent.SCHEMA, TagContent.ARRAY_OF_SCHEMAS), Collections.singletonList(SchemaType.ARRAY)),
    TAG_PREFIX_ITEMS(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "items" : "prefixItems", Collections.singletonList(TagContent.ARRAY_OF_SCHEMAS), Collections.singletonList(SchemaType.ARRAY)),
    TAG_UNEVALUATED_ITEMS("unevaluatedItems", Collections.singletonList(TagContent.SCHEMA), Collections.singletonList(SchemaType.ARRAY)),
    TAG_REQUIRED("required", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_DEPENDENT_SCHEMAS(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "dependencies" : "dependentSchemas", Collections.singletonList(TagContent.NAMED_SCHEMAS), Collections.singletonList(SchemaType.OBJECT)),
    TAG_DEPENDENT_REQUIRED(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "dependencies" : "dependentRequired", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_ADDITIONAL_PROPERTIES("additionalProperties", Collections.singletonList(TagContent.SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_PATTERN_PROPERTIES("patternProperties", Collections.singletonList(TagContent.NAMED_SCHEMAS), Collections.singletonList(SchemaType.OBJECT)),
    TAG_PROPERTIES_MIN("minProperties", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_PROPERTIES_MAX("maxProperties", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.OBJECT)),
    TAG_ALLOF("allOf", Collections.singletonList(TagContent.ARRAY_OF_SCHEMAS)),
    TAG_ANYOF("anyOf", Collections.singletonList(TagContent.ARRAY_OF_SCHEMAS)),
    TAG_ONEOF("oneOf", Collections.singletonList(TagContent.ARRAY_OF_SCHEMAS)),
    TAG_NOT("not", Collections.singletonList(TagContent.SCHEMA)),
    TAG_TITLE("title", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_DESCRIPTION("description", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_CONST("const", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_ENUM("enum", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_DEFAULT("default", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_READ_ONLY("readOnly", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_WRITE_ONLY("writeOnly", Collections.singletonList(TagContent.NON_SCHEMA)),
    TAG_LENGTH_MIN("minLength", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.STRING)),
    TAG_LENGTH_MAX("maxLength", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.STRING)),
    TAG_FORMAT("format", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.STRING)),
    TAG_PATTERN("pattern", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.STRING)),
    TAG_MINIMUM("minimum", Collections.singletonList(TagContent.NON_SCHEMA), Arrays.asList(SchemaType.INTEGER, SchemaType.NUMBER)),
    TAG_MINIMUM_EXCLUSIVE("exclusiveMinimum", Collections.singletonList(TagContent.NON_SCHEMA), Arrays.asList(SchemaType.INTEGER, SchemaType.NUMBER)),
    TAG_MAXIMUM("maximum", Collections.singletonList(TagContent.NON_SCHEMA), Arrays.asList(SchemaType.INTEGER, SchemaType.NUMBER)),
    TAG_MAXIMUM_EXCLUSIVE("exclusiveMaximum", Collections.singletonList(TagContent.NON_SCHEMA), Arrays.asList(SchemaType.INTEGER, SchemaType.NUMBER)),
    TAG_MULTIPLE_OF("multipleOf", Collections.singletonList(TagContent.NON_SCHEMA), Arrays.asList(SchemaType.INTEGER, SchemaType.NUMBER)),
    TAG_ITEMS_MIN("minItems", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.ARRAY)),
    TAG_ITEMS_MAX("maxItems", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.ARRAY)),
    TAG_ITEMS_UNIQUE("uniqueItems", Collections.singletonList(TagContent.NON_SCHEMA), Collections.singletonList(SchemaType.ARRAY)),
    TAG_IF("if", Collections.singletonList(TagContent.SCHEMA)),
    TAG_THEN("then", Collections.singletonList(TagContent.SCHEMA)),
    TAG_ELSE("else", Collections.singletonList(TagContent.SCHEMA));

    private final Function<SchemaVersion, String> valueProvider;
    private final List<TagContent> contentTypes;
    private final List<SchemaType> impliedTypes;

    private SchemaKeyword(String fixedValue) {
        this(fixedValue, Collections.emptyList(), Collections.emptyList());
    }

    private SchemaKeyword(String fixedValue, List<TagContent> contentTypes) {
        this((SchemaVersion _version) -> fixedValue, contentTypes, Collections.emptyList());
    }

    private SchemaKeyword(String fixedValue, List<TagContent> contentTypes, List<SchemaType> impliedTypes) {
        this((SchemaVersion _version) -> fixedValue, contentTypes, impliedTypes);
    }

    private SchemaKeyword(Function<SchemaVersion, String> valueProvider, List<TagContent> contentTypes, List<SchemaType> impliedTypes) {
        this.valueProvider = valueProvider;
        this.contentTypes = Collections.unmodifiableList(contentTypes);
        this.impliedTypes = Collections.unmodifiableList(impliedTypes);
    }

    public String forVersion(SchemaVersion version) {
        return this.valueProvider.apply(version);
    }

    public List<SchemaType> getImpliedTypes() {
        return this.impliedTypes;
    }

    public boolean supportsContentType(TagContent contentType) {
        return this.contentTypes.contains((Object)contentType);
    }

    public static Map<String, SchemaKeyword> getReverseTagMap(SchemaVersion version, Predicate<SchemaKeyword> filter) {
        return Stream.of(SchemaKeyword.values()).filter(keyword -> !keyword.contentTypes.isEmpty() && filter.test((SchemaKeyword)((Object)keyword))).collect(Collectors.toMap(keyword -> keyword.forVersion(version), keyword -> keyword, (k1, k2) -> k1));
    }

    public static enum TagContent {
        SCHEMA,
        ARRAY_OF_SCHEMAS,
        NAMED_SCHEMAS,
        NON_SCHEMA;

    }

    public static enum SchemaType {
        NULL("null"),
        ARRAY("array"),
        OBJECT("object"),
        BOOLEAN("boolean"),
        STRING("string"),
        INTEGER("integer"),
        NUMBER("number");

        private final String schemaKeywordValue;

        private SchemaType(String schemaKeywordValue) {
            this.schemaKeywordValue = schemaKeywordValue;
        }

        public String getSchemaKeywordValue() {
            return this.schemaKeywordValue;
        }
    }
}

