/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixRequestEvents;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SerialHystrixRequestEvents
extends SerialHystrixMetric {
    @Deprecated
    public static byte[] toBytes(HystrixRequestEvents requestEvents) {
        throw new UnsupportedOperationException("Not implemented anymore.  Will be implemented in a new class shortly");
    }

    public static String toJsonString(HystrixRequestEvents requestEvents) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixRequestEvents.serializeRequestEvents(requestEvents, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    private static void serializeRequestEvents(HystrixRequestEvents requestEvents, JsonGenerator json) {
        try {
            json.writeStartArray();
            for (Map.Entry entry : requestEvents.getExecutionsMappedToLatencies().entrySet()) {
                SerialHystrixRequestEvents.convertExecutionToJson(json, (HystrixRequestEvents.ExecutionSignature)entry.getKey(), (List)entry.getValue());
            }
            json.writeEndArray();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void convertExecutionToJson(JsonGenerator json, HystrixRequestEvents.ExecutionSignature executionSignature, List<Integer> latencies) throws IOException {
        json.writeStartObject();
        json.writeStringField("name", executionSignature.getCommandName());
        json.writeArrayFieldStart("events");
        ExecutionResult.EventCounts eventCounts = executionSignature.getEventCounts();
        for (HystrixEventType eventType : HystrixEventType.values()) {
            if (eventType.equals((Object)HystrixEventType.COLLAPSED) || !eventCounts.contains(eventType)) continue;
            int eventCount = eventCounts.getCount(eventType);
            if (eventCount > 1) {
                json.writeStartObject();
                json.writeStringField("name", eventType.name());
                json.writeNumberField("count", eventCount);
                json.writeEndObject();
                continue;
            }
            json.writeString(eventType.name());
        }
        json.writeEndArray();
        json.writeArrayFieldStart("latencies");
        Iterator<Integer> iterator = latencies.iterator();
        while (iterator.hasNext()) {
            int latency = (Integer)iterator.next();
            json.writeNumber(latency);
        }
        json.writeEndArray();
        if (executionSignature.getCachedCount() > 0) {
            json.writeNumberField("cached", executionSignature.getCachedCount());
        }
        if (executionSignature.getEventCounts().contains(HystrixEventType.COLLAPSED)) {
            json.writeObjectFieldStart("collapsed");
            json.writeStringField("name", executionSignature.getCollapserKey().name());
            json.writeNumberField("count", executionSignature.getCollapserBatchSize());
            json.writeEndObject();
        }
        json.writeEndObject();
    }
}

