/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.sync.data.zookeeper;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.springboot.sync.data.zookeeper.ZookeeperProperties;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperClient;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperConfig;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperSyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ZookeeperSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.zookeeper", name={"url"})
@EnableConfigurationProperties(value={ZookeeperProperties.class})
public class ZookeeperSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperSyncDataConfiguration.class);

    @Bean
    public SyncDataService syncDataService(ObjectProvider<ShenyuConfig> shenyuConfig, ObjectProvider<ZookeeperClient> zookeeperClient, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorDataSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers) {
        LOGGER.info("you use zookeeper sync shenyu data.......");
        return new ZookeeperSyncDataService((ShenyuConfig)shenyuConfig.getIfAvailable(), (ZookeeperClient)zookeeperClient.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorDataSubscribers.getIfAvailable(Collections::emptyList), (List)discoveryUpstreamDataSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    public ZookeeperClient zookeeperClient(ZookeeperProperties zookeeperProps) {
        int sessionTimeout = Objects.isNull(zookeeperProps.getSessionTimeout()) ? 3000 : zookeeperProps.getSessionTimeout();
        int connectionTimeout = Objects.isNull(zookeeperProps.getConnectionTimeout()) ? 3000 : zookeeperProps.getConnectionTimeout();
        ZookeeperConfig zkConfig = new ZookeeperConfig(zookeeperProps.getUrl());
        zkConfig.setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        ZookeeperClient client = new ZookeeperClient(zkConfig);
        client.start();
        return client;
    }
}

