/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.plugin;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.stat.CircuitBreakGauge;
import com.tencent.polaris.api.plugin.stat.RateLimitGauge;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategy;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategyCollections;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.StatInfoCollectorContainer;
import com.tencent.polaris.plugins.stat.common.model.StatInfoRevisionCollector;
import com.tencent.polaris.plugins.stat.common.model.StatMetric;
import com.tencent.polaris.plugins.stat.common.model.SystemMetricModel;
import com.tencent.polaris.plugins.stat.prometheus.exporter.PushGateway;
import com.tencent.polaris.plugins.stat.prometheus.handler.CommonHandler;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHandlerConfig;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHttpServer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import shade.polaris.io.prometheus.client.CollectorRegistry;
import shade.polaris.io.prometheus.client.Gauge;

public class PrometheusReporter
implements StatReporter,
PluginConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusReporter.class);
    private PrometheusHandlerConfig config;
    private final AtomicBoolean firstHandle = new AtomicBoolean(false);
    private CollectorRegistry promRegistry;
    private Map<String, Gauge> sampleMapping;
    private StatInfoCollectorContainer container = new StatInfoCollectorContainer();
    private String sdkIP;
    private String instanceID;
    private PrometheusHttpServer httpServer;
    private ScheduledExecutorService executorService;
    private PushGateway pushGateway;
    private Extensions extensions;
    private boolean enable;

    public PrometheusReporter() {
        this.sampleMapping = new HashMap<String, Gauge>();
        this.promRegistry = new CollectorRegistry(true);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
        this.initSampleMapping(MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY, SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
    }

    @Override
    public void init(InitContext initContext) throws PolarisException {
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
        this.extensions = extensions;
        this.config = extensions.getConfiguration().getGlobal().getStatReporter().getPluginConfig(this.getName(), PrometheusHandlerConfig.class);
        this.instanceID = extensions.getValueContext().getClientId();
        this.sdkIP = extensions.getValueContext().getHost();
        this.enable = extensions.getConfiguration().getGlobal().getStatReporter().isEnable();
        this.executorService = Executors.newScheduledThreadPool(4, new NamedThreadFactory(this.getName()));
        this.initHandle();
    }

    void initHandle() {
        if (!this.enable) {
            return;
        }
        if (this.firstHandle.compareAndSet(false, true)) {
            if (Objects.equals(this.config.getType(), "push")) {
                this.startSchedulePushTask();
            } else {
                this.startScheduleAggregationTask();
            }
        }
    }

    @Override
    public void reportStat(StatInfo statInfo) {
        if (!this.enable) {
            return;
        }
        if (Objects.isNull(statInfo)) {
            return;
        }
        this.handle(statInfo);
    }

    public void handle(StatInfo statInfo) {
        if (null != statInfo.getRouterGauge()) {
            this.handleRouterGauge(statInfo.getRouterGauge());
        }
        if (null != statInfo.getCircuitBreakGauge()) {
            this.handleCircuitBreakGauge(statInfo.getCircuitBreakGauge());
        }
        if (null != statInfo.getRateLimitGauge()) {
            this.handleRateLimitGauge(statInfo.getRateLimitGauge());
        }
    }

    public void handleRouterGauge(InstanceGauge instanceGauge) {
        if (null != this.container && null != this.container.getInsCollector()) {
            this.container.getInsCollector().collectStatInfo(instanceGauge, CommonHandler.convertInsGaugeToLabels(instanceGauge, this.sdkIP), MetricValueAggregationStrategyCollections.SERVICE_CALL_STRATEGY);
        }
    }

    public void handleCircuitBreakGauge(CircuitBreakGauge circuitBreakGauge) {
        if (null != this.container && null != this.container.getCircuitBreakerCollector()) {
            this.container.getCircuitBreakerCollector().collectStatInfo(circuitBreakGauge, CommonHandler.convertCircuitBreakToLabels(circuitBreakGauge, this.sdkIP), MetricValueAggregationStrategyCollections.CIRCUIT_BREAK_STRATEGY);
        }
    }

    public void handleRateLimitGauge(RateLimitGauge rateLimitGauge) {
        if (null != this.container && null != this.container.getRateLimitCollector()) {
            this.container.getRateLimitCollector().collectStatInfo(rateLimitGauge, CommonHandler.convertRateLimitGaugeToLabels(rateLimitGauge), MetricValueAggregationStrategyCollections.RATE_LIMIT_STRATEGY);
        }
    }

    private void initSampleMapping(MetricValueAggregationStrategy<?>[] strategies, String[] order) {
        for (MetricValueAggregationStrategy<?> strategy : strategies) {
            Gauge strategyGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)new Gauge.Builder().name(strategy.getStrategyName())).help(strategy.getStrategyDescription())).labelNames(order)).create().register(this.promRegistry);
            this.sampleMapping.put(strategy.getStrategyName(), strategyGauge);
        }
    }

    @Override
    public ReporterMetaInfo metaInfo() {
        if (!this.enable || Objects.equals(this.config.getType(), "push") || Objects.isNull(this.httpServer)) {
            return ReporterMetaInfo.builder().build();
        }
        return ReporterMetaInfo.builder().protocol("http").path(this.httpServer.getPath()).host(this.httpServer.getHost()).port(this.httpServer.getPort()).target(this.getName()).build();
    }

    @Override
    public String getName() {
        return "prometheus";
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return PrometheusHandlerConfig.class;
    }

    @Override
    public PluginType getType() {
        return PluginTypes.STAT_REPORTER.getBaseType();
    }

    @Override
    public void destroy() {
        if (Objects.isNull(this.config)) {
            return;
        }
        if (Objects.nonNull(this.executorService)) {
            this.executorService.shutdown();
        }
        if (Objects.nonNull(this.httpServer)) {
            this.httpServer.stopServer();
        }
    }

    private void startScheduleAggregationTask() {
        if (this.config.getPort() == -1) {
            this.enable = false;
            LOGGER.info("[Metrics][Prometheus] port == -1, disable run prometheus http-server and metrics report");
            return;
        }
        this.httpServer = new PrometheusHttpServer(this.config.getHost(), this.config.getPort(), this.promRegistry);
        if (null != this.container && null != this.executorService && null != this.sampleMapping) {
            this.executorService.scheduleWithFixedDelay(this::doAggregation, 30000L, 30000L, TimeUnit.MILLISECONDS);
            LOGGER.info("start schedule metric aggregation task, task interval {}", (Object)30000);
        }
    }

    private void doAggregation() {
        CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getInsCollector(), this.container.getInsCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
        CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getCircuitBreakerCollector(), 0L, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
        CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getRateLimitCollector(), this.container.getRateLimitCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
        for (StatInfoCollector<?, ? extends StatMetric> statInfoCollector : this.container.getCollectors()) {
            if (!(statInfoCollector instanceof StatInfoRevisionCollector)) continue;
            long currentRevision = ((StatInfoRevisionCollector)statInfoCollector).incRevision();
            LOGGER.debug("RevisionCollector inc current revision to {}", (Object)currentRevision);
        }
    }

    private void startSchedulePushTask() {
        List<String> addresses;
        if (StringUtils.isBlank(this.config.getAddress()) && CollectionUtils.isNotEmpty(addresses = this.extensions.getConfiguration().getGlobal().getServerConnector().getAddresses())) {
            String address = addresses.get(0);
            this.config.setAddress(address.split(":")[0] + ":" + 9091);
        }
        if (null != this.container && null != this.executorService && null != this.sampleMapping) {
            this.executorService.scheduleWithFixedDelay(this::doPush, this.config.getPushInterval(), this.config.getPushInterval(), TimeUnit.MILLISECONDS);
            LOGGER.info("start schedule push task, task interval {}", (Object)this.config.getPushInterval());
        }
    }

    private void doPush() {
        try {
            CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getInsCollector(), this.container.getInsCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.INSTANCE_GAUGE_LABEL_ORDER);
            CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getCircuitBreakerCollector(), 0L, SystemMetricModel.SystemMetricLabelOrder.CIRCUIT_BREAKER_LABEL_ORDER);
            CommonHandler.putDataFromContainerInOrder(this.sampleMapping, this.container.getRateLimitCollector(), this.container.getRateLimitCollector().getCurrentRevision(), SystemMetricModel.SystemMetricLabelOrder.RATELIMIT_GAUGE_LABEL_ORDER);
            try {
                if (Objects.isNull(this.pushGateway)) {
                    LOGGER.info("init push-gateway {} ", (Object)this.config.getAddress());
                    this.pushGateway = new PushGateway(this.config.getAddress());
                }
                if (this.config.isOpenGzip().booleanValue()) {
                    this.pushGateway.pushAddByGzip(this.promRegistry, "polaris-client", Collections.singletonMap("instance", this.instanceID));
                } else {
                    this.pushGateway.pushAdd(this.promRegistry, "polaris-client", Collections.singletonMap("instance", this.instanceID));
                }
                LOGGER.info("push result to push-gateway {} success, open gzip {}", (Object)this.config.getAddress(), (Object)this.config.isOpenGzip());
            }
            catch (IOException exception) {
                LOGGER.error("push result to push-gateway {} open gzip {} encountered exception, exception:{}", new Object[]{this.config.getAddress(), this.config.isOpenGzip(), exception.getMessage()});
                this.pushGateway = null;
                return;
            }
            for (StatInfoCollector<?, ? extends StatMetric> statInfoCollector : this.container.getCollectors()) {
                if (!(statInfoCollector instanceof StatInfoRevisionCollector)) continue;
                long currentRevision = ((StatInfoRevisionCollector)statInfoCollector).incRevision();
                LOGGER.debug("RevisionCollector inc current revision to {}", (Object)currentRevision);
            }
        }
        catch (Exception e) {
            LOGGER.error("push result to push-gateway {} open gzip {} encountered exception, exception:{}", new Object[]{this.config.getAddress(), this.config.isOpenGzip(), e.getMessage()});
        }
    }

    public PrometheusHandlerConfig getConfig() {
        return this.config;
    }

    public void setConfig(PrometheusHandlerConfig config) {
        this.config = config;
    }

    public CollectorRegistry getPromRegistry() {
        return this.promRegistry;
    }

    public void setPromRegistry(CollectorRegistry promRegistry) {
        this.promRegistry = promRegistry;
    }

    public PushGateway getPushGateway() {
        return this.pushGateway;
    }

    public void setPushGateway(PushGateway pushGateway) {
        this.pushGateway = pushGateway;
    }

    String getSdkIP() {
        return this.sdkIP;
    }

    void setSdkIP(String sdkIP) {
        this.sdkIP = sdkIP;
    }

    void setEnable(boolean enable) {
        this.enable = enable;
    }

    void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }
}

