/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import oshi.SystemInfo;

public final class SystemInfoUtils {
    private static final int BYTES_IN_KB = 1024;
    private static final int BYTES_IN_MB = 0x100000;
    private static final int BYTES_IN_GB = 0x40000000;
    private static final int DECIMAL_PLACES = 2;
    private static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;

    public static String getSystemInfo() {
        try {
            SystemInfo systemInfo = new SystemInfo();
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            Map<String, CallSite> hostInfo = Map.of("arch", osBean.getArch(), "operatingSystem", systemInfo.getOperatingSystem().toString(), "availableProcessors", osBean.getAvailableProcessors(), "totalMemorySizeGB", SystemInfoUtils.bytesToGB(osBean.getTotalMemorySize()) + "GB");
            return GsonUtils.getInstance().toJson(hostInfo);
        }
        catch (Exception e) {
            throw new ShenyuException("Error retrieving system information: " + e.getMessage());
        }
    }

    private static double bytesToGB(long bytesValue) {
        return BigDecimal.valueOf((double)bytesValue / 1.073741824E9).setScale(2, ROUNDING_MODE).doubleValue();
    }
}

