/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.OssShipperStorageColumn;
import com.aliyun.openservices.log.common.OssShipperStorageDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;

public class OssShipperParquetStorageDetail
extends OssShipperStorageDetail
implements Serializable {
    private static final long serialVersionUID = 1407883828765925579L;
    private ArrayList<OssShipperStorageColumn> storageColumns = new ArrayList();

    OssShipperParquetStorageDetail() {
        this.setStorageFormat("parquet");
    }

    public ArrayList<OssShipperStorageColumn> getStorageColumns() {
        return this.storageColumns;
    }

    public void setStorageColumns(ArrayList<OssShipperStorageColumn> storageColumns) {
        this.storageColumns = new ArrayList<OssShipperStorageColumn>(storageColumns);
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject obj = new JSONObject();
        JSONArray columns = new JSONArray();
        for (OssShipperStorageColumn column : this.storageColumns) {
            columns.add((Object)column.ToJsonObject());
        }
        JSONObject detail = new JSONObject();
        detail.put("columns", (Object)columns);
        JSONObject storage = new JSONObject();
        storage.put("detail", (Object)detail);
        storage.put("format", (Object)this.getStorageFormat());
        obj.put("storage", (Object)storage);
        return obj;
    }

    @Override
    public void FromJsonObject(JSONObject storageDetail) throws LogException {
        try {
            JSONObject storage = storageDetail.getJSONObject("storage");
            this.setStorageFormat(storage.getString("format"));
            JSONObject detail = storage.getJSONObject("detail");
            JSONArray columns = detail.getJSONArray("columns");
            ArrayList<OssShipperStorageColumn> storageColumns = new ArrayList<OssShipperStorageColumn>();
            if (columns != null) {
                for (int index = 0; index < columns.size(); ++index) {
                    JSONObject colAsJson = columns.getJSONObject(index);
                    if (colAsJson == null) continue;
                    storageColumns.add(new OssShipperStorageColumn(colAsJson.getString("name"), colAsJson.getString("type")));
                }
            }
            this.setStorageColumns(storageColumns);
        }
        catch (JSONException ex) {
            throw new LogException("FailToParseOssShipperParquetStorageDetail", ex.getMessage(), ex, "");
        }
    }
}

