/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.aot;

import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public class McpHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        MemberCategory[] mcs = MemberCategory.values();
        for (TypeReference tr : this.innerClasses(McpSchema.class)) {
            hints.reflection().registerType(tr, mcs);
        }
    }

    private Set<TypeReference> innerClasses(Class<?> clazz) {
        HashSet<String> indent = new HashSet<String>();
        this.findNestedClasses(clazz, indent);
        return indent.stream().map(TypeReference::of).collect(Collectors.toSet());
    }

    private void findNestedClasses(Class<?> clazz, Set<String> indent) {
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(clazz.getDeclaredClasses()));
        classes.addAll(Arrays.asList(clazz.getClasses()));
        for (Class clazz2 : classes) {
            this.findNestedClasses(clazz2, indent);
        }
        indent.addAll(classes.stream().map(Class::getName).toList());
    }
}

