/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.cache.support.expiring;

import java.util.Map;
import org.apache.dubbo.cache.Cache;
import org.apache.dubbo.cache.support.expiring.ExpiringMap;
import org.apache.dubbo.common.URL;

public class ExpiringCache
implements Cache {
    private final Map<Object, Object> store;

    public ExpiringCache(URL url) {
        int secondsToLive = url.getParameter("cache.seconds", 180);
        int intervalSeconds = url.getParameter("cache.interval", 4);
        ExpiringMap<Object, Object> expiringMap = new ExpiringMap<Object, Object>(secondsToLive, intervalSeconds);
        expiringMap.getExpireThread().startExpiryIfNotStarted();
        this.store = expiringMap;
    }

    @Override
    public void put(Object key, Object value) {
        this.store.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.store.get(key);
    }
}

