/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.java.JavaObjectInput;
import org.apache.dubbo.common.serialize.java.JavaObjectOutput;

public class JavaSerialization
implements Serialization {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(JavaSerialization.class);
    private static final AtomicBoolean warn = new AtomicBoolean(false);

    @Override
    public byte getContentTypeId() {
        return 3;
    }

    @Override
    public String getContentType() {
        return "x-application/java";
    }

    @Override
    public ObjectOutput serialize(URL url, OutputStream out) throws IOException {
        if (warn.compareAndSet(false, true)) {
            logger.error("4-4", "", "", "Java serialization is unsafe. Dubbo Team do not recommend anyone to use it.If you still want to use it, please follow [JEP 290](https://openjdk.java.net/jeps/290)to set serialization filter to prevent deserialization leak.");
        }
        return new JavaObjectOutput(out);
    }

    @Override
    public ObjectInput deserialize(URL url, InputStream is) throws IOException {
        if (warn.compareAndSet(false, true)) {
            logger.error("4-4", "", "", "Java serialization is unsafe. Dubbo Team do not recommend anyone to use it.If you still want to use it, please follow [JEP 290](https://openjdk.java.net/jeps/290)to set serialization filter to prevent deserialization leak.");
        }
        return new JavaObjectInput(is);
    }
}

