/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.extension;

import java.util.Arrays;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringExtensionInjector
implements ExtensionInjector {
    private ApplicationContext context;

    @Deprecated
    public static void addApplicationContext(ApplicationContext context) {
    }

    public static SpringExtensionInjector get(ExtensionAccessor extensionAccessor) {
        return (SpringExtensionInjector)extensionAccessor.getExtension(ExtensionInjector.class, "spring");
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void init(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> T getInstance(Class<T> type, String name) {
        if (this.context == null) {
            return null;
        }
        if (type.isInterface() && type.isAnnotationPresent(SPI.class)) {
            return null;
        }
        T bean = this.getOptionalBean((ListableBeanFactory)this.context, name, type);
        if (bean != null) {
            return bean;
        }
        return null;
    }

    private <T> T getOptionalBean(ListableBeanFactory beanFactory, String name, Class<T> type) {
        if (StringUtils.isEmpty(name)) {
            return this.getOptionalBeanByType(beanFactory, type);
        }
        if (beanFactory.containsBean(name)) {
            return (T)beanFactory.getBean(name, type);
        }
        return null;
    }

    private <T> T getOptionalBeanByType(ListableBeanFactory beanFactory, Class<T> type) {
        Object[] beanNamesForType = beanFactory.getBeanNamesForType(type, true, false);
        if (beanNamesForType == null) {
            return null;
        }
        if (beanNamesForType.length > 1) {
            throw new IllegalStateException("Expect single but found " + beanNamesForType.length + " beans in spring context: " + Arrays.toString(beanNamesForType));
        }
        return (T)beanFactory.getBean(beanNamesForType[0], type);
    }
}

